/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.util;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

public class ChainableOptional<T> {
    private Optional<T> delegate;

    ChainableOptional(Optional<? extends T> src) {
        this.delegate = src;
    }

    public static <T> ChainableOptional<T> of(Optional<? extends T> src) {
        return new ChainableOptional<T>(src);
    }

    public static <T> ChainableOptional<T> of(Supplier<Optional<? extends T>> src) {
        return ChainableOptional.of((Optional)src.get());
    }

    public ChainableOptional<T> or(Supplier<Optional<? extends T>> secondChoice) {
        if (this.delegate.isPresent()) {
            return this;
        }
        return ChainableOptional.of(secondChoice);
    }

    public T orFinally(Supplier<T> finalChoice) {
        return (T)this.delegate.or(finalChoice);
    }

    public T orFinally(T finalChoice) {
        return (T)this.delegate.or(Suppliers.ofInstance(finalChoice));
    }
}

