/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;

public final class Optionals {
    private Optionals() {
    }

    public static <T> Optional<T> or(Optional<T> mayT, Supplier<Optional<T>> alternative) {
        if (mayT.isPresent()) {
            return mayT;
        }
        return (Optional)alternative.get();
    }

    public static <T> Optional<T> flatten(Optional<Optional<T>> mayMayT) {
        return (Optional)mayMayT.or((Object)Optional.absent());
    }

    public static <S, T> Optional<T> flatTransform(Optional<S> src, Function<S, Optional<T>> f) {
        return Optionals.flatten(src.transform(f));
    }

    public static <S, T> Iterable<T> flatTransform(Iterable<S> xs, Function<S, Optional<T>> f) {
        return Optional.presentInstances((Iterable)Iterables.transform(xs, f));
    }

    public static Predicate<Optional<?>> isPresentPr() {
        return IsPresentPr.INSTANCE;
    }

    private static enum IsPresentPr implements Predicate<Optional<?>>
    {
        INSTANCE;


        public boolean apply(Optional<?> input) {
            return input.isPresent();
        }

        public String toString() {
            return "is present";
        }
    }
}

