/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.geonames;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.mapton.api.MBookmark;
import org.mapton.api.MContextMenuItem;
import org.mapton.api.MLatLon;
import org.mapton.geonames.api.GeonamesManager;

public class DuckDuckGo
extends MContextMenuItem {
    public String getName() {
        return "DuckDuckGo";
    }

    public MContextMenuItem.ContextType getType() {
        return MContextMenuItem.ContextType.OPEN;
    }

    public String getUrl() {
        MLatLon hereLatLon = new MLatLon(this.getLongitude(), this.getLatitude());
        MBookmark nearest = new MBookmark();
        double dist = Double.MAX_VALUE;
        for (MBookmark bookmark : this.getResults()) {
            MLatLon bookmarkLatLon = new MLatLon(bookmark.getLongitude().doubleValue(), bookmark.getLatitude().doubleValue());
            double newDistance = hereLatLon.distance(bookmarkLatLon);
            if (!(newDistance < dist)) continue;
            dist = newDistance;
            nearest = bookmark;
            if (!(dist < 1000.0)) continue;
            break;
        }
        try {
            return "https://duckduckgo.com/?q=%s".formatted(URLEncoder.encode(nearest.getName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    private ArrayList<MBookmark> getResults() {
        ArrayList<MBookmark> bookmarks = new ArrayList<MBookmark>();
        GeonamesManager.getInstance().getGeonames().stream().forEachOrdered(g -> {
            MBookmark b = new MBookmark();
            b.setName(g.getName());
            b.setCategory(g.getCountryCode());
            b.setLatitude(g.getLatitude());
            b.setLongitude(g.getLongitude());
            b.setZoom(Double.valueOf(0.5));
            bookmarks.add(b);
        });
        return bookmarks;
    }
}

