/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.geonames;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.mapton.api.MPrint;
import org.mapton.api.Mapton;
import org.mapton.geonames.api.Geoname;
import se.trixon.almond.util.MathHelper;

public class GeonamesGenerator {
    private final File mCacheDir;
    private final File mCities1000txtFile;
    private final File mCities1000zipFile;
    private final ArrayList<Geoname> mGeonames = new ArrayList();
    private MPrint mPrint;
    private final File mSearchEngineFile;

    public static GeonamesGenerator getInstance() {
        return Holder.INSTANCE;
    }

    public static void main(String[] args) throws IOException {
    }

    private GeonamesGenerator() {
        this.mCacheDir = new File(Mapton.getCacheDir(), "geonames");
        this.mCities1000zipFile = new File(this.mCacheDir, "cities1000.zip");
        this.mCities1000txtFile = new File(this.mCacheDir, "cities1000.txt");
        this.mSearchEngineFile = new File(this.mCacheDir, "geonames.json");
    }

    public File getCities1000zipFile() {
        return this.mCities1000zipFile;
    }

    public File getSearchEngineFile() {
        return this.mSearchEngineFile;
    }

    public void update(MPrint print) throws IOException {
        this.mPrint = print;
        this.mPrint.out("GeoNames: Download https://download.geonames.org/export/dump/cities1000.zip");
        FileUtils.copyURLToFile((URL)new URL("https://download.geonames.org/export/dump/cities1000.zip"), (File)this.mCities1000zipFile, (int)5000, (int)5000);
        this.mPrint.out("GeoNames: Extract cities1000.txt");
        this.extractZip();
        this.populateCities();
        this.mPrint.out("GeoNames: Save geonames.json");
        this.saveJson();
    }

    private void extractZip() throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + this.mCities1000zipFile.toURI().toString());
        try (FileSystem fileSystem = FileSystems.newFileSystem(uri, env);){
            Path path = fileSystem.getPath("cities1000.txt", new String[0]);
            FileUtils.writeByteArrayToFile((File)this.mCities1000txtFile, (byte[])Files.readAllBytes(path));
        }
    }

    private void populateCities() throws IOException {
        try (CSVParser csvRecords = CSVParser.parse((File)new File(this.mCacheDir, "cities1000.txt"), (Charset)Charset.forName("utf-8"), (CSVFormat)CSVFormat.DEFAULT.builder().setHeader(new String[0]).setAllowMissingColumnNames(true).setDelimiter('\t').build());){
            for (CSVRecord csvRecord : csvRecords) {
                String name = csvRecord.get(1);
                String asciiname = csvRecord.get(2);
                String alternateames = csvRecord.get(3);
                Double lat = MathHelper.convertStringToDouble((String)csvRecord.get(4));
                Double lon = MathHelper.convertStringToDouble((String)csvRecord.get(5));
                String countryCode = csvRecord.get(8);
                Integer population = MathHelper.convertStringToInteger((String)csvRecord.get(14));
                Integer elevation = MathHelper.convertStringToInteger((String)csvRecord.get(15));
                Geoname geoname = new Geoname();
                geoname.setName(name);
                geoname.setAsciiName(asciiname);
                geoname.setAlternateNames(alternateames);
                geoname.setCountryCode(countryCode);
                geoname.setLatitude(lat);
                geoname.setLongitude(lon);
                geoname.setPopulation(population);
                geoname.setElevation(elevation);
                this.mGeonames.add(geoname);
            }
            this.mGeonames.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        }
    }

    private void saveJson() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileUtils.write((File)this.mSearchEngineFile, (CharSequence)gson.toJson(this.mGeonames), (String)"utf-8");
    }

    private static class Holder {
        private static final GeonamesGenerator INSTANCE = new GeonamesGenerator();

        private Holder() {
        }
    }
}

