/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.geonames.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.TreeMap;
import org.mapton.geonames.GeoNamesQuickSearchProvider;
import org.mapton.geonames.api.Country;
import se.trixon.almond.util.SystemHelper;

public class CountryManager {
    private final TreeMap<String, Country> mCodeCountryMap = new TreeMap();
    private final TreeMap<String, String> mCodeNameMap = new TreeMap();
    private ArrayList<Country> mCountryList;

    public static CountryManager getInstance() {
        return Holder.INSTANCE;
    }

    private CountryManager() {
        Gson gson = new GsonBuilder().create();
        String json = SystemHelper.getResourceAsString(GeoNamesQuickSearchProvider.class, (String)"country_codes.json");
        this.mCountryList = (ArrayList)gson.fromJson(json, new TypeToken<ArrayList<Country>>(){}.getType());
        this.mCountryList.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.mCountryList.forEach(country -> {
            this.mCodeCountryMap.put(country.getCode(), (Country)country);
            this.mCodeNameMap.put(country.getCode(), country.getName());
        });
    }

    public TreeMap<String, Country> getCodeCountryMap() {
        return this.mCodeCountryMap;
    }

    public TreeMap<String, String> getCodeNameMap() {
        return this.mCodeNameMap;
    }

    public ArrayList<Country> getCountryList() {
        return this.mCountryList;
    }

    private static class Holder {
        private static final CountryManager INSTANCE = new CountryManager();

        private Holder() {
        }
    }
}

