/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.geonames.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.geonames.GeonamesGenerator;
import org.mapton.geonames.api.Country;
import org.mapton.geonames.api.CountryManager;
import org.mapton.geonames.api.Geoname;
import org.openide.util.Exceptions;

public class GeonamesManager {
    private final GeonamesGenerator mGenerator = GeonamesGenerator.getInstance();
    private ArrayList<Geoname> mGeonames = new ArrayList();

    public static GeonamesManager getInstance() {
        return Holder.INSTANCE;
    }

    private GeonamesManager() {
        this.init();
    }

    public ArrayList<Geoname> getGeonames() {
        return this.mGeonames;
    }

    public void init() {
        new Thread(() -> {
            Gson gson = new GsonBuilder().create();
            if (this.mGenerator.getSearchEngineFile().isFile()) {
                try {
                    String json = FileUtils.readFileToString((File)this.mGenerator.getSearchEngineFile(), (String)"utf-8");
                    this.mGeonames = (ArrayList)gson.fromJson(json, new TypeToken<ArrayList<Geoname>>(){}.getType());
                    TreeMap<String, ArrayList> countries = new TreeMap<String, ArrayList>();
                    for (Geoname geoname : this.mGeonames) {
                        countries.computeIfAbsent(geoname.getCountryCode(), k -> new ArrayList()).add(geoname);
                    }
                    for (String countryCode : countries.keySet()) {
                        Country country = CountryManager.getInstance().getCodeCountryMap().get(countryCode);
                        try {
                            ArrayList geonames = (ArrayList)countries.get(countryCode);
                            country.setGeonames(geonames);
                            ArrayList<MLatLon> latLons = new ArrayList<MLatLon>();
                            for (Geoname geoname : geonames) {
                                latLons.add(new MLatLon(geoname.getLatitude().doubleValue(), geoname.getLongitude().doubleValue()));
                            }
                            country.setLatLonBox(new MLatLonBox(latLons));
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, this.getClass().getCanonicalName()).start();
    }

    private static class Holder {
        private static final GeonamesManager INSTANCE = new GeonamesManager();

        private Holder() {
        }
    }
}

