/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.client;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;

public final class NominatimResponseHandler<T>
implements ResponseHandler<T> {
    private final Gson gsonInstance;
    private final Type responseType;

    public NominatimResponseHandler(Gson gsonInstance, Type responseType) {
        this.gsonInstance = gsonInstance;
        this.responseType = responseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T handleResponse(HttpResponse response) throws IOException {
        Object addresses;
        InputStream content = null;
        try {
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() >= 400) {
                throw new IOException(String.format("HTTP error: %s %s", status.getStatusCode(), status.getReasonPhrase()));
            }
            content = response.getEntity().getContent();
            addresses = this.gsonInstance.fromJson((Reader)new InputStreamReader(content, "utf-8"), this.responseType);
        }
        finally {
            if (null != content) {
                content.close();
            }
            response.getEntity().consumeContent();
        }
        return (T)addresses;
    }
}

