/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolbox.Helper;

public class CornerRadii {
    private double topLeft;
    private double topRight;
    private double bottomRight;
    private double bottomLeft;

    public CornerRadii() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public CornerRadii(double radius) {
        this(radius, radius, radius, radius);
    }

    public CornerRadii(double topLeft, double topRight, double bottomRight, double bottomLeft) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
    }

    public double getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(double value) {
        this.topLeft = Helper.clamp((double)0.0, (double)Double.MAX_VALUE, (double)value);
    }

    public double getTopRight() {
        return this.topRight;
    }

    public void setTopRight(double value) {
        this.topRight = Helper.clamp((double)0.0, (double)Double.MAX_VALUE, (double)value);
    }

    public double getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(double value) {
        this.bottomRight = Helper.clamp((double)0.0, (double)Double.MAX_VALUE, (double)value);
    }

    public double getBottomLeft() {
        return this.bottomLeft;
    }

    public void setBottomLeft(double value) {
        this.bottomLeft = Helper.clamp((double)0.0, (double)Double.MAX_VALUE, (double)value);
    }

    public String toString() {
        return "{" + "\"" + "topLeft" + "\"" + ":" + this.getTopLeft() + "," + "\"" + "topRight" + "\"" + ":" + this.getTopRight() + "," + "\"" + "bottomRight" + "\"" + ":" + this.getBottomRight() + "," + "\"" + "bottomLeft" + "\"" + ":" + this.getBottomLeft() + "}";
    }
}

