/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.actions.quicknav;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.event.ActionListener;
import org.mapton.api.MLatLon;
import org.mapton.api.MOptions;
import org.mapton.api.Mapton;

public abstract class QuickNavAction
implements ActionListener {
    private final Gson mGson = new GsonBuilder().create();
    private final String mId;
    private final MOptions mOptions = MOptions.getInstance();
    private static final String PREFIX = "QuickNav_";

    public QuickNavAction(String id) {
        this.mId = id;
    }

    protected void get() {
        QuickNav quickNav = (QuickNav)this.mGson.fromJson(this.mOptions.get(PREFIX + this.mId, new String[0]), QuickNav.class);
        if (quickNav != null) {
            Mapton.getEngine().panTo(new MLatLon(quickNav.lat, quickNav.lon), quickNav.zoom);
        }
    }

    protected void set() {
        MLatLon latLon = Mapton.getEngine().getCenter();
        QuickNav quickNav = new QuickNav(latLon.getLatitude(), latLon.getLongitude(), Mapton.getEngine().getZoom());
        this.mOptions.put(PREFIX + this.mId, this.mGson.toJson((Object)quickNav));
    }

    public class QuickNav {
        private double lat;
        private double lon;
        private double zoom;

        public QuickNav(double lat, double lon, double zoom) {
            this.lat = lat;
            this.lon = lon;
            this.zoom = zoom;
        }
    }
}

