/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.api;

import java.awt.Dimension;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.action.Action;
import org.mapton.api.MBookmark;
import org.mapton.api.MBookmarkManager;
import org.mapton.api.Mapton;
import org.mapton.core.ui.bookmark.BookmarkPanel;
import org.mapton.core.ui.bookmark.CategoryPanel;
import org.mapton.core.ui.bookmark.ColorPanel;
import org.mapton.core.ui.bookmark.ZoomPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.dialogs.NbMessage;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.SwingHelper;

public class BookmarkEditor {
    private final ResourceBundle mBundle = NbBundle.getBundle(MBookmarkManager.class);
    private final MBookmarkManager mManager = MBookmarkManager.getInstance();

    public void editBookmark(MBookmark aBookmark) {
        SwingUtilities.invokeLater(() -> {
            boolean add;
            MBookmark newBookmark = aBookmark;
            boolean bl = add = aBookmark == null;
            if (add) {
                newBookmark = new MBookmark();
                newBookmark.setZoom(Double.valueOf(Mapton.getEngine().getZoom()));
                newBookmark.setLatitude(Mapton.getEngine().getLockedLatitude());
                newBookmark.setLongitude(Mapton.getEngine().getLockedLongitude());
            }
            MBookmark bookmark = newBookmark;
            BookmarkPanel bookmarkPanel = new BookmarkPanel();
            DialogDescriptor d = new DialogDescriptor((Object)bookmarkPanel, Dict.BOOKMARK.toString());
            bookmarkPanel.setNotifyDescriptor((NotifyDescriptor)d);
            bookmarkPanel.initFx(() -> bookmarkPanel.load(bookmark));
            bookmarkPanel.setPreferredSize(SwingHelper.getUIScaledDim((int)300, (int)550));
            if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)d)) {
                bookmarkPanel.save(bookmark);
                Platform.runLater(() -> {
                    try {
                        if (add) {
                            this.mManager.dbInsert(bookmark);
                        } else {
                            bookmark.setTimeModified(new Timestamp(System.currentTimeMillis()));
                            this.mManager.dbUpdate(bookmark);
                            this.mManager.dbLoad();
                        }
                    }
                    catch (ClassNotFoundException | SQLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
            }
        });
    }

    public void editCategory(String category) {
        SwingUtilities.invokeLater(() -> {
            String newCategory;
            CategoryPanel categoryPanel = new CategoryPanel();
            DialogDescriptor d = new DialogDescriptor((Object)categoryPanel, Dict.EDIT.toString());
            categoryPanel.setNotifyDescriptor((NotifyDescriptor)d);
            categoryPanel.initFx(() -> categoryPanel.setCategory(category));
            categoryPanel.setPreferredSize(SwingHelper.getUIScaledDim((int)400, (int)100));
            if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)d) && !StringUtils.equals((CharSequence)category, (CharSequence)(newCategory = categoryPanel.getCategory()))) {
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                TreeSet<String> bookmarkNames = new TreeSet<String>();
                for (MBookmark bookmark : this.mManager.getItems()) {
                    if (!StringUtils.startsWith((CharSequence)bookmark.getCategory(), (CharSequence)category)) continue;
                    String oldCategory = bookmark.getCategory();
                    bookmark.setCategory(StringUtils.replaceOnce((String)bookmark.getCategory(), (String)category, (String)newCategory));
                    bookmark.setTimeModified(timestamp);
                    try {
                        this.mManager.dbUpdate(bookmark);
                    }
                    catch (SQLException ex) {
                        bookmarkNames.add("%s/%s".formatted(oldCategory, bookmark.getName()));
                    }
                }
                Platform.runLater(() -> this.mManager.dbLoad());
                if (!bookmarkNames.isEmpty()) {
                    String delim = "\n \u25c6 ";
                    NbMessage.error(Dict.Dialog.ERROR.toString(), "%s\n%s%s".formatted(this.mBundle.getString("bookmark_rename_category_error"), delim, String.join((CharSequence)delim, bookmarkNames)));
                }
            }
        });
    }

    public void editColor(String category) {
        SwingUtilities.invokeLater(() -> {
            ColorPanel colorPanel = new ColorPanel();
            DialogDescriptor d = new DialogDescriptor((Object)colorPanel, Dict.EDIT.toString());
            colorPanel.setNotifyDescriptor((NotifyDescriptor)d);
            colorPanel.initFx(() -> {});
            colorPanel.setPreferredSize(SwingHelper.getUIScaledDim((int)200, (int)100));
            if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)d)) {
                String color = colorPanel.getColor();
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                for (MBookmark bookmark : this.mManager.getItems()) {
                    if (!StringUtils.startsWith((CharSequence)bookmark.getCategory(), (CharSequence)category)) continue;
                    bookmark.setColor(color);
                    bookmark.setTimeModified(timestamp);
                    try {
                        this.mManager.dbUpdate(bookmark);
                    }
                    catch (SQLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                Platform.runLater(() -> this.mManager.dbLoad());
            }
        });
    }

    public void editZoom(String category) {
        SwingUtilities.invokeLater(() -> {
            ZoomPanel zoomPanel = new ZoomPanel();
            DialogDescriptor d = new DialogDescriptor((Object)zoomPanel, Dict.EDIT.toString());
            zoomPanel.setNotifyDescriptor((NotifyDescriptor)d);
            zoomPanel.initFx(() -> {});
            zoomPanel.setPreferredSize(new Dimension(200, 100));
            if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)d)) {
                double zoom = zoomPanel.getZoom();
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                for (MBookmark bookmark : this.mManager.getItems()) {
                    if (!StringUtils.startsWith((CharSequence)bookmark.getCategory(), (CharSequence)category)) continue;
                    bookmark.setZoom(Double.valueOf(zoom));
                    bookmark.setTimeModified(timestamp);
                    try {
                        this.mManager.dbUpdate(bookmark);
                    }
                    catch (SQLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                Platform.runLater(() -> this.mManager.dbLoad());
            }
        });
    }

    public Action getAddBookmarkAction() {
        Action action = new Action(Dict.ADD_BOOKMARK.toString(), acttionEvent -> this.editBookmark(null));
        return action;
    }

    public void remove(MBookmark bookmark) {
        SwingUtilities.invokeLater(() -> {
            Object[] buttons = new String[]{Dict.CANCEL.toString(), Dict.REMOVE.toString()};
            NotifyDescriptor d = new NotifyDescriptor((Object)Dict.Dialog.MESSAGE_PROFILE_REMOVE.toString().formatted(bookmark.getName()), Dict.Dialog.TITLE_BOOKMARK_REMOVE.toString() + "?", 2, 2, buttons, (Object)Dict.REMOVE.toString());
            if (Dict.REMOVE.toString() == DialogDisplayer.getDefault().notify(d)) {
                Platform.runLater(() -> {
                    try {
                        if (bookmark.isCategory().booleanValue()) {
                            this.mManager.dbDelete(bookmark.getCategory());
                        } else {
                            this.mManager.dbDelete(bookmark);
                        }
                    }
                    catch (ClassNotFoundException | SQLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
            }
        });
    }

    public void removeAll() {
        SwingUtilities.invokeLater(() -> {
            Object[] buttons = new String[]{Dict.CANCEL.toString(), Dict.REMOVE_ALL.toString()};
            NotifyDescriptor d = new NotifyDescriptor((Object)Dict.Dialog.MESSAGE_BOOKMARK_REMOVE_ALL.toString(), Dict.Dialog.TITLE_BOOKMARK_REMOVE_ALL.toString() + "?", 2, 2, buttons, (Object)Dict.REMOVE_ALL.toString());
            if (Dict.REMOVE_ALL.toString() == DialogDisplayer.getDefault().notify(d)) {
                Platform.runLater(() -> {
                    try {
                        this.mManager.dbDelete();
                    }
                    catch (ClassNotFoundException | SQLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
            }
        });
    }
}

