/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.cootrans;

import javafx.geometry.Point2D;
import org.mapton.api.MBounds;
import org.mapton.api.MCooTrans;

public class Wgs84
implements MCooTrans {
    private final MBounds mBoundsProjected = new MBounds(-180.0, -90.0, 180.0, 90.0);
    private final MBounds mBoundsWgs84 = new MBounds(-180.0, -90.0, 180.0, 90.0);

    public Point2D fromWgs84(double latitude, double longitude) {
        return new Point2D(longitude, latitude);
    }

    public MBounds getBoundsProjected() {
        return this.mBoundsProjected;
    }

    public MBounds getBoundsWgs84() {
        return this.mBoundsWgs84;
    }

    public double getLatitude(double latitude, double longitude) {
        return latitude;
    }

    public String getLatitudeString(double latitude, double longitude) {
        return "%2.6f".formatted(latitude);
    }

    public double getLongitude(double latitude, double longitude) {
        return longitude;
    }

    public String getLongitudeString(double latitude, double longitude) {
        return "%3.6f".formatted(longitude);
    }

    public String getName() {
        return "WGS 84";
    }

    public String getString(double latitude, double longitude) {
        return "%s %s".formatted(this.getLatitudeString(latitude, longitude), this.getLongitudeString(latitude, longitude));
    }

    public boolean isOrthogonal() {
        return false;
    }

    public boolean isWithinProjectedBounds(double latitude, double longitude) {
        return this.mBoundsProjected.contains(longitude, latitude);
    }

    public boolean isWithinWgs84Bounds(double latitude, double longitude) {
        return this.mBoundsWgs84.contains(longitude, latitude);
    }

    public String toString() {
        return this.getName();
    }

    public Point2D toWgs84(double latitude, double longitude) {
        return new Point2D(longitude, latitude);
    }
}

