/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.cootrans;

import javafx.geometry.Point2D;
import org.mapton.api.MBounds;
import org.mapton.api.MCooTrans;
import org.mapton.api.MDecDegDMS;

public class Wgs84DMS
implements MCooTrans {
    private final MBounds mBoundsProjected = new MBounds(-180.0, -90.0, 180.0, 90.0);
    private final MBounds mBoundsWgs84 = new MBounds(-180.0, -90.0, 180.0, 90.0);

    public Point2D fromWgs84(double latitude, double longitude) {
        return new Point2D(longitude, latitude);
    }

    public MBounds getBoundsProjected() {
        return this.mBoundsProjected;
    }

    public MBounds getBoundsWgs84() {
        return this.mBoundsWgs84;
    }

    public double getLatitude(double latitude, double longitude) {
        return latitude;
    }

    public String getLatitudeString(double latitude, double longitude) {
        MDecDegDMS dddms = new MDecDegDMS(latitude, true);
        return dddms.format("%2d\u00b0%2d'%4.1f\"%s", "N", "S");
    }

    public double getLongitude(double latitude, double longitude) {
        return longitude;
    }

    public String getLongitudeString(double latitude, double longitude) {
        MDecDegDMS dddms = new MDecDegDMS(longitude, true);
        return dddms.format("%3d\u00b0%2d'%4.1f\"%s", "E", "W");
    }

    public String getName() {
        return "WGS 84 DMS";
    }

    public String getString(double latitude, double longitude) {
        return "%s %s".formatted(this.getLatitudeString(latitude, longitude), this.getLongitudeString(latitude, longitude));
    }

    public boolean isOrthogonal() {
        return false;
    }

    public boolean isWithinProjectedBounds(double latitude, double longitude) {
        return this.mBoundsProjected.contains(longitude, latitude);
    }

    public boolean isWithinWgs84Bounds(double latitude, double longitude) {
        return this.mBoundsWgs84.contains(longitude, latitude);
    }

    public String toString() {
        return this.getName();
    }

    public Point2D toWgs84(double latitude, double longitude) {
        return new Point2D(longitude, latitude);
    }
}

