/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.reports;

import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.HtmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MBookmark;
import org.mapton.api.MBookmarkManager;
import org.mapton.api.report.MReportSystem;
import se.trixon.almond.util.Dict;

public class BookmarkReport
extends MReportSystem {
    private final MBookmarkManager mManager = MBookmarkManager.getInstance();
    private final String mName = Dict.BOOKMARKS.toString();

    public BookmarkReport() {
        this.setName(this.mName);
    }

    public ContainerTag getContent() {
        TreeMap<String, ArrayList> bookmarkCategories = new TreeMap<String, ArrayList>();
        for (MBookmark bookmark : this.mManager.dbLoad("*", false)) {
            bookmarkCategories.computeIfAbsent(bookmark.getCategory(), k -> new ArrayList()).add(bookmark);
        }
        HtmlTag html = TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)this.mName)}), TagCreator.body((DomContent[])new DomContent[]{TagCreator.h1((String)this.mName), TagCreator.hr(), TagCreator.div((DomContent[])new DomContent[]{TagCreator.each(bookmarkCategories.keySet(), category -> TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)category), TagCreator.table((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)Dict.NAME.toString()), TagCreator.th((String)Dict.DESCRIPTION.toString()), TagCreator.th((String)"URL"), TagCreator.th((String)Dict.LATITUDE.toString()), TagCreator.th((String)Dict.LONGITUDE.toString())}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each((Collection)TagCreator.filter((Collection)this.mManager.dbLoad(), bookmark -> bookmark.getCategory().equals(category)), bookmark -> TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)bookmark.getName()), TagCreator.td((String)StringUtils.defaultString((String)bookmark.getDescription())), TagCreator.td((String)StringUtils.defaultString((String)bookmark.getUrl())), TagCreator.td((String)"%.6f".formatted(bookmark.getLatitude())), TagCreator.td((String)"%.6f".formatted(bookmark.getLongitude()))}))})})}))})})});
        return html;
    }
}

