/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.status;

import java.awt.Component;
import java.awt.event.ActionListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.border.EmptyBorder;
import org.mapton.api.MCooTrans;
import org.mapton.api.MCrsManager;
import org.mapton.api.MOptions;
import org.mapton.api.Mapton;
import org.openide.awt.StatusLineElementProvider;
import se.trixon.almond.util.swing.SwingHelper;

public class CoordinateSystemStatusLineElement
implements StatusLineElementProvider {
    private ActionListener mActionListener;
    private JComboBox<MCooTrans> mComboBox;
    private MCooTrans mCooTrans;
    private final MCrsManager mManager = MCrsManager.getInstance();
    private final MOptions mOptions = MOptions.getInstance();

    public Component getStatusLineElement() {
        if (this.mComboBox == null) {
            this.init();
            this.initListeners();
            this.updateProviders();
        }
        return this.mComboBox;
    }

    private void init() {
        this.mComboBox = new JComboBox();
        this.mComboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    private void initListeners() {
        this.mActionListener = actionEvent -> {
            this.mCooTrans = (MCooTrans)this.mComboBox.getModel().getSelectedItem();
            this.mOptions.setMapCooTrans(this.mCooTrans.getName());
            this.updateMousePositionData();
        };
        ((ObservableList)this.mManager.itemsProperty().get()).addListener(c -> this.updateProviders());
    }

    private void updateMousePositionData() {
        Mapton.getGlobalState().put("Status.Coordinate", Mapton.getGlobalState().get("Status.Coordinate"));
    }

    private void updateProviders() {
        SwingHelper.runLater(() -> {
            this.mComboBox.removeActionListener(this.mActionListener);
            this.mComboBox.removeAllItems();
            SortedList cooTranses = this.mManager.getItems().sorted((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
            this.mComboBox.setModel(new DefaultComboBoxModel<MCooTrans>((MCooTrans[])cooTranses.toArray((Object[])new MCooTrans[0])));
            for (MCooTrans cooTrans : cooTranses) {
                Mapton.logLoading((String)"Coordinate Transformation", (String)cooTrans.getName());
            }
            if (!cooTranses.isEmpty()) {
                MCooTrans cooTrans = MCooTrans.getCooTrans((String)this.mOptions.getMapCooTransName());
                if (cooTrans == null) {
                    cooTrans = (MCooTrans)this.mComboBox.getModel().getElementAt(0);
                }
                this.mComboBox.getModel().setSelectedItem(cooTrans);
                this.mCooTrans = (MCooTrans)this.mComboBox.getModel().getSelectedItem();
                this.updateMousePositionData();
            }
            this.mComboBox.addActionListener(this.mActionListener);
        });
    }
}

