/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui;

import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.HtmlTag;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import org.controlsfx.control.PopOver;
import org.mapton.api.MAttribution;
import org.mapton.api.MDocumentInfo;
import org.mapton.api.Mapton;
import org.openide.util.NbBundle;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;

public class AttributionView
extends BorderPane {
    private final ResourceBundle mBundle = NbBundle.getBundle(AttributionView.class);
    private PopOver mPopOver;
    private WebView mWebView;

    public AttributionView() {
        this.createUI();
        this.initListeners();
    }

    public AttributionView(PopOver popOver) {
        this.mPopOver = popOver;
        this.createUI();
        this.initListeners();
        this.updateDocumentInfo((MDocumentInfo)Mapton.getGlobalState().get("map.document.info"));
    }

    private void createUI() {
        this.mWebView = new WebView();
        this.mWebView.setPrefSize((double)FxHelper.getUIScaled((int)500), (double)FxHelper.getUIScaled((int)300));
        Mapton.applyHtmlCss((WebView)this.mWebView, (String)"attribution.css");
        this.setCenter((Node)this.mWebView);
    }

    private void initListeners() {
        Mapton.getGlobalState().addListener(evt -> Platform.runLater(() -> {
            MDocumentInfo documentInfo = (MDocumentInfo)evt.getValue();
            this.updateDocumentInfo(documentInfo);
        }), new String[]{"map.document.info"});
        this.mWebView.getEngine().getLoadWorker().stateProperty().addListener((ov, t, t1) -> {
            if (t1 == Worker.State.SUCCEEDED) {
                NodeList nodeList = this.mWebView.getEngine().getDocument().getElementsByTagName("a");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    org.w3c.dom.Node node = nodeList.item(i);
                    EventTarget eventTarget = (EventTarget)((Object)node);
                    eventTarget.addEventListener("click", evt -> {
                        EventTarget target = evt.getCurrentTarget();
                        HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                        String href = anchorElement.getHref();
                        if (this.mPopOver != null) {
                            this.mPopOver.hide();
                        }
                        SystemHelper.desktopBrowse((String)href);
                        evt.preventDefault();
                    }, false);
                }
            }
        });
    }

    private void updateDocumentInfo(MDocumentInfo documentInfo) {
        HtmlTag html;
        if (documentInfo != null) {
            LinkedHashMap<MAttribution, String> keys = new LinkedHashMap<MAttribution, String>();
            LinkedHashMap attributions = documentInfo.getAttributions();
            for (Map.Entry entry : attributions.entrySet()) {
                keys.put((MAttribution)entry.getValue(), (String)entry.getKey());
            }
            html = TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)documentInfo.getName())}), TagCreator.body((DomContent[])new DomContent[]{TagCreator.h1((String)documentInfo.getName()), TagCreator.hr(), TagCreator.each(attributions.values(), attribution -> TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)((String)keys.get(attribution))), TagCreator.p((DomContent[])new DomContent[]{(DomContent)TagCreator.iff((!attribution.isOnlyRaw() ? 1 : 0) != 0, (Object)TagCreator.rawHtml((String)this.mBundle.getString("attribution").formatted(attribution.getProviderUrl(), attribution.getProviderName(), attribution.getLicenseUrl(), attribution.getLicenseName())))}), TagCreator.p((DomContent[])new DomContent[]{TagCreator.rawHtml((String)attribution.getRawHtml())}), TagCreator.hr()}))})});
        } else {
            html = TagCreator.html();
        }
        this.mWebView.getEngine().loadContent(html.render());
    }
}

