/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javax.swing.SwingUtilities;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.api.MDict;
import org.mapton.api.MDocumentInfo;
import org.mapton.api.MOptions;
import org.mapton.api.MToolMapCommand;
import org.mapton.api.Mapton;
import org.mapton.core.api.BaseToolBar;
import org.mapton.core.ui.AttributionView;
import org.mapton.core.ui.LayerView;
import org.mapton.core.ui.RulerView;
import org.mapton.core.ui.TemporalView;
import org.mapton.core.ui.bookmark.BookmarksView;
import org.mapton.core.ui.poi.PoisViewManager;
import org.openide.awt.Actions;
import org.openide.util.Lookup;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxActionSwing;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class MapToolBar
extends BaseToolBar {
    private final String CSS_FILE = ((Object)((Object)this)).getClass().getResource("toolbar_map.css").toExternalForm();
    private Action mAttributionAction;
    private PopOver mAttributionPopOver;
    private AttributionView mAttributionView;
    private Action mBookmarkAction;
    private PopOver mBookmarkPopOver;
    private Action mCommandAction;
    private ContextMenu mCommandContextMenu;
    private ObservableList<MenuItem> mCommandMenuItems;
    private FxActionSwing mHomeAction;
    private Action mLayerAction;
    private PopOver mLayerPopOver;
    private Action mPoiAction;
    private PopOver mPoiPopOver;
    private Action mRulerAction;
    private PopOver mRulerPopOver;
    private Action mStyleAction;
    private PopOver mStylePopOver;
    private FxActionSwing mStyleSwapAction;
    private Action mTemporalAction;
    private PopOver mTemporalPopOver;
    private TemporalView mTemporalView;

    public MapToolBar() {
        this.initPopOvers();
        this.initActionsFx();
        this.initActionsSwing();
        this.init();
        this.initListeners();
        this.refreshEngine();
        Mapton.getGlobalState().put("map.document.info", Mapton.getGlobalState().get("map.document.info"));
    }

    public void toogleAttributionPopOver() {
        this.tooglePopOver(this.mAttributionPopOver, this.mAttributionAction);
    }

    public void toogleBookmarkPopOver() {
        this.tooglePopOver(this.mBookmarkPopOver, this.mBookmarkAction);
    }

    public void toogleCommandContextMenu() {
        FxHelper.runLater(() -> {
            if (this.mCommandContextMenu.isShowing()) {
                this.mCommandContextMenu.hide();
            } else if (this.shouldOpen(this.mCommandContextMenu)) {
                this.mCommandContextMenu.show((Node)this.getButtonForAction(this.mCommandAction), Side.BOTTOM, 0.0, 0.0);
                this.getScene().getWindow().requestFocus();
                this.mCommandContextMenu.requestFocus();
            }
        });
    }

    public void toogleLayerPopOver() {
        this.tooglePopOver(this.mLayerPopOver, this.mLayerAction);
    }

    public void tooglePoiPopOver() {
        this.tooglePopOver(this.mPoiPopOver, this.mPoiAction);
    }

    public void toogleRulerPopOver() {
        if (Mapton.getEngine().getRulerView() != null) {
            this.tooglePopOver(this.mRulerPopOver, this.mRulerAction);
        }
    }

    public void toogleStylePopOver() {
        this.tooglePopOver(this.mStylePopOver, this.mStyleAction);
    }

    public void toogleTemporalPopOver() {
        this.tooglePopOver(this.mTemporalPopOver, this.mTemporalAction);
    }

    private void init() {
        this.setStyle("-fx-spacing: 0px;");
        this.setPadding(Insets.EMPTY);
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(this.mHomeAction, this.mCommandAction, this.mAttributionAction, this.mStyleSwapAction, this.mStyleAction, this.mBookmarkAction, this.mPoiAction, this.mLayerAction, ActionUtils.ACTION_SPAN, this.mTemporalAction, this.mRulerAction));
        Platform.runLater(() -> {
            ActionUtils.updateToolBar((ToolBar)this, (Collection)actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
            this.storeButtonWidths(this.mStyleAction, this.mTemporalAction, this.mRulerAction);
            FxHelper.adjustButtonHeight((Stream)this.getItems().stream(), (double)((double)Mapton.getIconSizeToolBarInt() * 1.5));
            FxHelper.adjustButtonWidth((Stream)this.getItems().stream(), (double)((double)Mapton.getIconSizeToolBarInt() * 1.0));
            FxHelper.undecorateButtons((Stream)this.getItems().stream());
            FxHelper.slimToolBar((ToolBar)this);
            this.setTextFromActions();
            this.mCommandContextMenu = new ContextMenu();
            this.mCommandContextMenu.setOnHiding(windowEvent -> this.onObjectHiding(this.mCommandContextMenu));
            this.mCommandMenuItems = this.mCommandContextMenu.getItems();
            Lookup.getDefault().lookupResult(MToolMapCommand.class).addLookupListener(event -> this.populateCommands());
            this.populateCommands();
            this.getButtonForAction(this.mLayerAction).setVisible(false);
            this.getButtonForAction(this.mPoiAction).setVisible(false);
            this.getButtonForAction(this.mBookmarkAction).setVisible(false);
        });
    }

    private void initActionsFx() {
        this.mBookmarkAction = new Action(Dict.BOOKMARKS.toString(), event -> {
            if (this.usePopOver(this.mBookmarkPopOver)) {
                if (this.shouldOpen(this.mBookmarkPopOver)) {
                    this.show(this.mBookmarkPopOver, (Object)this);
                }
            } else {
                SwingUtilities.invokeLater(() -> Actions.forID((String)"Mapton", (String)"org.mapton.core.actions.BookmarkAction").actionPerformed(null));
            }
        });
        this.mPoiAction = new Action(MDict.POI.toString(), event -> {
            if (this.usePopOver(this.mPoiPopOver)) {
                if (this.shouldOpen(this.mPoiPopOver)) {
                    this.show(this.mPoiPopOver, (Object)this);
                }
            } else {
                SwingUtilities.invokeLater(() -> Actions.forID((String)"Mapton", (String)"org.mapton.core.actions.PoiAction").actionPerformed(null));
            }
        });
        this.mLayerAction = new Action(Dict.LAYERS.toString(), event -> {
            if (this.usePopOver(this.mLayerPopOver)) {
                if (this.shouldOpen(this.mLayerPopOver)) {
                    this.show(this.mLayerPopOver, (Object)this);
                }
            } else {
                SwingUtilities.invokeLater(() -> Actions.forID((String)"Mapton", (String)"org.mapton.core.actions.LayerAction").actionPerformed(null));
            }
        });
        this.mCommandAction = new Action(Dict.COMMANDS.toString(), event -> this.toogleCommandContextMenu());
        this.mCommandAction.setGraphic((Node)MaterialIcon._Image.FLASH_ON.getImageView(Mapton.getIconSizeToolBarInt()));
        FxHelper.setTooltip((Action)this.mCommandAction, (KeyCodeCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.mStyleAction = new Action(event -> {
            if (this.shouldOpen(this.mStylePopOver)) {
                BorderPane borderPane = (BorderPane)this.mStylePopOver.getContentNode();
                borderPane.setCenter(Mapton.getEngine().getStyleView());
                this.show(this.mStylePopOver, event.getSource());
            }
        });
        this.mStyleAction.setGraphic((Node)MaterialIcon._Image.COLOR_LENS.getImageView(Mapton.getIconSizeToolBarInt()));
        this.mStyleAction.setDisabled(true);
        FxHelper.setTooltip((Action)this.mStyleAction, (KeyCodeCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.mRulerAction = new Action(Dict.RULER.toString(), event -> this.toogleRulerPopOver());
        this.mRulerAction.setGraphic((Node)MaterialIcon._Editor.SPACE_BAR.getImageView(Mapton.getIconSizeToolBarInt()));
        this.mRulerAction.setDisabled(true);
        FxHelper.setTooltip((Action)this.mRulerAction, (KeyCodeCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.mRulerAction.textProperty().bind((ObservableValue)this.mRulerPopOver.titleProperty());
        this.mTemporalAction = new Action(Dict.Time.DATE.toString(), event -> this.toogleTemporalPopOver());
        this.mTemporalAction.setGraphic((Node)MaterialIcon._Action.DATE_RANGE.getImageView(Mapton.getIconSizeToolBarInt()));
        FxHelper.setTooltip((Action)this.mTemporalAction, (KeyCodeCombination)new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.mTemporalAction.textProperty().bind((ObservableValue)this.mTemporalView.titleProperty());
        this.mAttributionAction = new Action("Copyright", event -> {
            if (this.shouldOpen(this.mAttributionPopOver)) {
                this.show(this.mAttributionPopOver, event.getSource());
            }
        });
        this.mAttributionAction.setGraphic((Node)MaterialIcon._Action.COPYRIGHT.getImageView(Mapton.getIconSizeToolBarInt()));
        this.mAttributionAction.setDisabled(true);
    }

    private void initActionsSwing() {
        this.mHomeAction = new FxActionSwing(Dict.HOME.toString(), () -> Actions.forID((String)"Mapton", (String)"org.mapton.core.actions.HomeAction").actionPerformed(null));
        this.mHomeAction.setGraphic((Node)MaterialIcon._Action.HOME.getImageView(Mapton.getIconSizeToolBarInt()));
        FxHelper.setTooltip((Action)this.mHomeAction, (KeyCodeCombination)new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.mStyleSwapAction = new FxActionSwing(MDict.PREVIOUS_STYLE.toString(), () -> Actions.forID((String)"Mapton", (String)"org.mapton.core.actions.StyleSwapAction").actionPerformed(null));
        this.mStyleSwapAction.setGraphic((Node)MaterialIcon._Action.SWAP_HORIZ.getImageView(Mapton.getIconSizeToolBarInt()));
        this.mStyleSwapAction.disabledProperty().bind((ObservableValue)this.mStyleAction.disabledProperty());
        FxHelper.setTooltip((Action)this.mStyleSwapAction, (KeyCodeCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCodeCombination.SHIFT_DOWN}));
    }

    private void initListeners() {
        MOptions.getInstance().engineProperty().addListener((ov, t, t1) -> this.refreshEngine());
        Mapton.getGlobalState().addListener(evt -> Platform.runLater(() -> this.updateDocumentInfo((MDocumentInfo)evt.getValue())), new String[]{"map.document.info"});
    }

    private void initPopOvers() {
        this.mBookmarkPopOver = new PopOver();
        this.initPopOver(this.mBookmarkPopOver, Dict.BOOKMARKS.toString(), (Node)new BookmarksView(this.mBookmarkPopOver), false);
        this.mBookmarkPopOver.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
        this.mPoiPopOver = new PopOver();
        this.initPopOver(this.mPoiPopOver, MDict.POI.toString(), (Node)PoisViewManager.getInstance().getPoisView(), false);
        this.mPoiPopOver.setOnShowing(event -> {
            this.mPoiPopOver.setContentNode(null);
            this.mPoiPopOver.setContentNode((Node)PoisViewManager.getInstance().getPoisView());
            this.setPopOverWidths(FxHelper.getUIScaled((int)350), this.mPoiPopOver);
        });
        this.mPoiPopOver.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
        this.mLayerPopOver = new PopOver();
        this.initPopOver(this.mLayerPopOver, Dict.LAYERS.toString(), null, false);
        this.mLayerPopOver.setOnShowing(event -> {
            this.mLayerPopOver.setContentNode(null);
            this.mLayerPopOver.setContentNode((Node)LayerView.getInstance());
            this.setPopOverWidths(FxHelper.getUIScaled((int)350), this.mLayerPopOver);
        });
        this.mLayerPopOver.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
        this.mStylePopOver = new PopOver();
        this.initPopOver(this.mStylePopOver, "%s & %s".formatted(Dict.TYPE.toString(), Dict.STYLE.toString()), (Node)new BorderPane(), true);
        this.mStylePopOver.setOnShowing(event -> this.getButtonForAction(this.mStyleAction).getStylesheets().remove((Object)this.CSS_FILE));
        this.mStylePopOver.setOnHiding(event -> {
            this.getButtonForAction(this.mStyleAction).getStylesheets().add((Object)this.CSS_FILE);
            this.onObjectHiding(this.mStylePopOver);
        });
        this.mRulerPopOver = new PopOver();
        this.initPopOver(this.mRulerPopOver, Dict.RULER.toString(), (Node)new RulerView(), true);
        this.mRulerPopOver.setArrowLocation(PopOver.ArrowLocation.TOP_RIGHT);
        this.mRulerPopOver.setAutoHide(false);
        this.mRulerPopOver.setCloseButtonEnabled(true);
        this.mRulerPopOver.setDetachable(true);
        this.mTemporalPopOver = new PopOver();
        this.mTemporalView = new TemporalView();
        this.initPopOver(this.mTemporalPopOver, Dict.Time.DATE.toString(), (Node)this.mTemporalView, true);
        this.mTemporalPopOver.setArrowLocation(PopOver.ArrowLocation.TOP_RIGHT);
        this.mTemporalPopOver.setAutoHide(false);
        this.mTemporalPopOver.setCloseButtonEnabled(true);
        this.mTemporalPopOver.setDetachable(true);
        this.mTemporalPopOver.setOnShowing(event -> this.getButtonForAction(this.mTemporalAction).getStylesheets().remove((Object)this.CSS_FILE));
        this.mTemporalPopOver.setOnHiding(event -> {
            this.getButtonForAction(this.mTemporalAction).getStylesheets().add((Object)this.CSS_FILE);
            this.onObjectHiding(this.mTemporalPopOver);
        });
        this.setPopOverWidths(FxHelper.getUIScaled((int)350), this.mBookmarkPopOver, this.mPoiPopOver);
        Platform.runLater(() -> {
            this.mAttributionPopOver = new PopOver();
            this.mAttributionView = new AttributionView(this.mAttributionPopOver);
            this.initPopOver(this.mAttributionPopOver, Dict.COPYRIGHT.toString(), (Node)this.mAttributionView, true);
            this.mAttributionPopOver.setArrowLocation(PopOver.ArrowLocation.TOP_LEFT);
        });
    }

    private void populateCommands() {
        new Thread(() -> {
            this.mCommandMenuItems.clear();
            Lookup.getDefault().lookupAll(MToolMapCommand.class).forEach(command -> {
                MenuItem menuItem = new MenuItem(command.getAction().getText());
                menuItem.setAccelerator((KeyCombination)command.getKeyCodeCombination());
                menuItem.setOnAction(actionEvent -> command.getAction().handle(null));
                this.mCommandMenuItems.add((Object)menuItem);
            });
            if (!this.mCommandMenuItems.isEmpty()) {
                this.mCommandMenuItems.sort((o1, o2) -> o1.getText().compareTo(o2.getText()));
            }
        }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
    }

    private void refreshEngine() {
        this.mStyleAction.setDisabled(Mapton.getEngine().getStyleView() == null);
        this.mRulerAction.setDisabled(Mapton.getEngine().getRulerView() == null);
    }

    private void updateDocumentInfo(MDocumentInfo documentInfo) {
        this.mAttributionAction.setDisabled(false);
        if (documentInfo != null) {
            this.mStyleAction.setText(documentInfo.getName());
        }
    }
}

