/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui;

import java.awt.Dimension;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.controlsfx.control.NotificationPane;
import org.mapton.api.MBannerManager;
import org.mapton.api.Mapton;
import org.mapton.core.ui.MapToolBar;
import se.trixon.almond.util.fx.FxHelper;

public class MapToolBarPanel {
    private Label mNotificationLabel;
    private NotificationPane mNotificationPane;
    private final MapToolBar mToolBar;
    private final JFXPanel mToolBarPanel = new JFXPanel();

    public static MapToolBarPanel getInstance() {
        return Holder.INSTANCE;
    }

    private MapToolBarPanel() {
        this.mToolBarPanel.setVisible(false);
        this.mToolBarPanel.setPreferredSize(new Dimension(100, (int)((double)Mapton.getIconSizeToolBarInt() * 1.5)));
        this.mToolBar = new MapToolBar();
        Platform.runLater(() -> {
            this.mNotificationPane = new NotificationPane((Node)this.mToolBar);
            this.mNotificationLabel = new Label();
            this.mNotificationLabel.setBackground(FxHelper.createBackground((Color)Color.RED));
            this.mNotificationLabel.setPadding(FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)0.0, (double)8.0));
            this.mNotificationLabel.prefHeightProperty().bind((ObservableValue)this.mNotificationPane.heightProperty());
            this.mNotificationLabel.prefWidthProperty().bind((ObservableValue)this.mNotificationPane.widthProperty());
            this.mNotificationLabel.setFont(Font.font((double)(Font.getDefault().getSize() * 1.4)));
            this.mNotificationLabel.setTextFill((Paint)Color.WHITE);
            MBannerManager bannerManager = MBannerManager.getInstance();
            bannerManager.messageProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    FxHelper.runLater(() -> {
                        this.mNotificationLabel.setText(newValue);
                        this.mNotificationLabel.setGraphic(bannerManager.getGraphic());
                        this.mNotificationPane.show("", (Node)this.mNotificationLabel);
                    });
                }
            });
            Scene scene = new Scene((Parent)this.mNotificationPane);
            this.mToolBarPanel.setScene(scene);
            this.mToolBarPanel.setVisible(true);
            FxHelper.loadDarkTheme((Scene)this.mToolBarPanel.getScene());
        });
    }

    public MapToolBar getToolBar() {
        return this.mToolBar;
    }

    public JFXPanel getToolBarPanel() {
        return this.mToolBarPanel;
    }

    private static class Holder {
        private static final MapToolBarPanel INSTANCE = new MapToolBarPanel();

        private Holder() {
        }
    }
}

