/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.SystemUtils;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MDict;
import org.mapton.api.MEngine;
import org.mapton.api.MOptions;
import org.mapton.api.Mapton;
import org.mapton.core.api.MTopComponent;
import org.mapton.core.api.MaptonNb;
import org.mapton.core.ui.MapContextMenu;
import org.mapton.core.ui.MapToolBarPanel;
import org.mapton.core.ui.file_drop_switchboard.FileDropSwitchboard;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import se.trixon.almond.nbp.dialogs.NbSnapHelper;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.DelayedResetRunner;
import se.trixon.almond.util.swing.SwingHelper;
import se.trixon.almond.util.swing.dialogs.SimpleDialog;

@TopComponent.Description(preferredID="MapTopComponent", persistenceType=0)
public final class MapTopComponent
extends MTopComponent {
    private boolean mMapInitialized = false;
    private JPanel mProgressPanel;
    private BorderPane mRoot;

    public MapTopComponent() {
        this.setName(Dict.MAP.toString());
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.dragging_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.undocking_disabled", Boolean.TRUE);
        this.putClientProperty("print.name", "Mapton - %s".formatted(Dict.MAP.toString()));
        HashMap map = FileChooserHelper.getExtensionFilters();
        map.put("*", new FileNameExtensionFilter(Dict.ALL_FILES.toString(), "*"));
        map.put("csv", new FileNameExtensionFilter("Comma-separated value (*.csv)", "csv"));
        map.put("geo", new FileNameExtensionFilter("SBG Geo (*.geo)", "geo"));
        map.put("json", new FileNameExtensionFilter("JSON (*.json)", "json"));
        map.put("kml", new FileNameExtensionFilter("Keyhole Markup Language (*.kml)", "kml"));
        map.put("kmz", new FileNameExtensionFilter("Keyhole Markup Language (*.kmz)", "kmz"));
        map.put("grid", new FileNameExtensionFilter("Mapton Grid (*.grid)", "grid"));
        map.put("png", new FileNameExtensionFilter("%s (*.png)".formatted(Dict.IMAGE.toString()), "png"));
        map.put("txt", new FileNameExtensionFilter("%s (*.txt)".formatted(Dict.TEXT.toString()), "txt"));
        map.put("pdf", new FileNameExtensionFilter("Portable Document Format (*.pdf)", "pdf"));
        SimpleDialog.getExtensionFilters().putAll(map);
    }

    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (this.mMOptions.isDisplayCrosshair() && !"WorldWind".equalsIgnoreCase(this.mMOptions.getEngine())) {
                Graphics2D g2 = (Graphics2D)g;
                int x = this.getWidth() / 2;
                int y = (this.getHeight() + MapToolBarPanel.getInstance().getToolBarPanel().getHeight()) / 2;
                int gap = SwingHelper.getUIScaled((int)6);
                int length = SwingHelper.getUIScaled((int)6) + gap;
                Stroke[] strokes = new Stroke[]{new BasicStroke(SwingHelper.getUIScaled((int)5)), new BasicStroke(SwingHelper.getUIScaled((int)2))};
                Color[] colors = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.4f), Color.WHITE};
                for (int i = 0; i < 2; ++i) {
                    g2.setStroke(strokes[i]);
                    g2.setColor(colors[i]);
                    g2.drawLine(x, y + gap, x, y + length);
                    g2.drawLine(x, y - gap, x, y - length);
                    g2.drawLine(x + gap, y, x + length, y);
                    g2.drawLine(x - gap, y, x - length, y);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void componentHidden() {
        super.componentHidden();
        WindowManager.getDefault().findTopComponentGroup("MapGroup").close();
    }

    @Override
    protected void componentShowing() {
        super.componentShowing();
        WindowManager.getDefault().findTopComponentGroup("MapGroup").open();
    }

    @Override
    protected void fxPostConstructor() {
        super.fxPostConstructor();
        SwingHelper.runLater(() -> {
            this.removeAll();
            JLabel label = new JLabel("<html>%s<br/><br/><br/></html>".formatted(Dict.PATIENCE_IS_A_VIRTUE.toString()));
            label.setVerticalAlignment(3);
            label.setFont(label.getFont().deriveFont((float)label.getFont().getSize() * 2.0f));
            label.setHorizontalAlignment(0);
            this.add(label, "Center");
            MOptions.getInstance().engineProperty().addListener((ov, t, t1) -> SwingHelper.runLater(() -> this.setEngine(Mapton.getEngine())));
            this.setEngine(Mapton.getEngine());
        });
    }

    @Override
    protected void initFX() {
        this.setScene(this.createScene());
        new MapContextMenu();
        this.mMOptions.displayCrosshairProperty().addListener((ov, t, t1) -> {
            this.repaint();
            this.revalidate();
        });
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    private Scene createScene() {
        this.mRoot = new BorderPane();
        this.initListeners();
        return new Scene((Parent)this.mRoot);
    }

    private void initListeners() {
        this.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                try {
                    List dropObjects;
                    dtde.acceptDrop(1);
                    Object transferData = dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (transferData instanceof List && !(dropObjects = (List)transferData).isEmpty()) {
                        SwingHelper.requestWindowFocusAndRun((Component)((Object)MapTopComponent.this), () -> new FileDropSwitchboard(dropObjects));
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.mRoot.setOnDragOver(dragEvent -> {
            Dragboard board = dragEvent.getDragboard();
            if (board.hasFiles()) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        });
        this.mRoot.setOnDragDropped(dragEvent -> new FileDropSwitchboard(dragEvent.getDragboard().getFiles()));
        DelayedResetRunner delayedResetRunner = new DelayedResetRunner(10, () -> {
            try {
                JRootPane rootPane = this.getRootPane();
                Dimension originalSize = rootPane.getSize();
                SwingUtilities.invokeLater(() -> {
                    rootPane.setSize(new Dimension(originalSize.width - 1, originalSize.height - 0));
                    this.revalidate();
                    this.repaint();
                    SwingUtilities.invokeLater(() -> {
                        rootPane.setSize(originalSize);
                        this.revalidate();
                        this.repaint();
                    });
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        SwingUtilities.invokeLater(() -> this.addHierarchyListener(hierarchyEvent -> {
            if (SystemUtils.IS_OS_WINDOWS && hierarchyEvent.getChangedParent() instanceof JLayeredPane) {
                delayedResetRunner.reset();
            }
        }));
        Mapton.getGlobalState().addListener(gsce -> {
            double state = (Double)gsce.getValue();
            if (-1.0 == state) {
                MaptonNb.progressStart(Dict.RENDERING.toString());
                SwingHelper.runLaterDelayed((long)TimeUnit.SECONDS.toMillis(3L), () -> MaptonNb.progressStop(Dict.RENDERING.toString()));
            } else {
                MaptonNb.progressStop(Dict.RENDERING.toString());
            }
        }, new String[]{"Status.Progress"});
    }

    private synchronized void markMapAsInitialized() {
        if (!this.mMapInitialized) {
            this.mMapInitialized = true;
            new Thread(() -> {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                Mapton.getExecutionFlow().setReady("execution_flow_map_initialized");
                NbSnapHelper.checkSnapStatus(Mapton.class, "snap", "mapton", "removable-media");
            }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
        }
    }

    private void setEngine(MEngine engine) {
        this.setToolTipText("%s: %s".formatted(MDict.MAP_ENGINE.toString(), engine.getName()));
        this.putClientProperty("print.printable", !engine.getName().equalsIgnoreCase("WorldWind"));
        if (engine.isSwing()) {
            if (this.mProgressPanel == null) {
                this.mProgressPanel = new JPanel(new BorderLayout());
                JProgressBar progressBar = new JProgressBar();
                progressBar.setIndeterminate(true);
                this.mProgressPanel.add((Component)progressBar, "North");
            }
            this.removeAll();
            this.add((Component)MapToolBarPanel.getInstance().getToolBarPanel(), "North");
            this.add(this.mProgressPanel, "Center");
            Runnable postCreateRunnable = () -> {
                JComponent engineUI = engine.getMapComponent();
                Dimension dimension = new Dimension(1, 1);
                engineUI.setMinimumSize(dimension);
                engineUI.setPreferredSize(dimension);
                this.remove(this.mProgressPanel);
                this.add(engineUI, "Center");
                try {
                    engine.onActivate();
                    engine.panTo(this.mMOptions.getMapCenter(), this.mMOptions.getMapZoom());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.revalidate();
                this.repaint();
                this.markMapAsInitialized();
            };
            engine.create(postCreateRunnable);
        } else {
            this.resetFx();
            this.add((Component)MapToolBarPanel.getInstance().getToolBarPanel(), "North");
            Runnable postCreateRunnable = () -> {
                this.mRoot.setCenter(engine.getMapNode());
                try {
                    engine.onActivate();
                    engine.panTo(this.mMOptions.getMapCenter(), this.mMOptions.getMapZoom());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(() -> {
                    this.revalidate();
                    this.repaint();
                    this.markMapAsInitialized();
                });
            };
            engine.create(postCreateRunnable);
        }
        Mapton.logLoading((String)"Map Engine", (String)engine.getName());
    }
}

