/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui;

import java.time.LocalDate;
import java.util.Locale;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.controlsfx.control.ToggleSwitch;
import org.mapton.api.MTemporalManager;
import se.trixon.almond.util.DateHelper;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.control.DatePane;
import se.trixon.almond.util.fx.control.DateSelectionMode;

public class TemporalView
extends BorderPane {
    private DatePane mDatePane;
    private final MTemporalManager mManager = MTemporalManager.getInstance();
    private SplitMenuButton mPresetSplitMenuButton;
    private final StringProperty mTitleProperty = new SimpleStringProperty();
    private ToggleSwitch mToggleSwitch;

    public TemporalView() {
        this.createUI();
        this.populatePresets();
        this.initListeners();
        this.mToggleSwitch.setSelected(true);
        this.setDisable(true);
        this.mDatePane.setMinMaxDate(this.mManager.getMinDate(), this.mManager.getMaxDate());
        this.mManager.refresh();
    }

    public StringProperty titleProperty() {
        return this.mTitleProperty;
    }

    private void createUI() {
        this.setPrefWidth(FxHelper.getUIScaled((int)300));
        this.setPadding(FxHelper.getUIScaledInsets((double)8.0));
        this.mDatePane = new DatePane();
        this.mPresetSplitMenuButton = new SplitMenuButton();
        this.mPresetSplitMenuButton.setText(Dict.RESET.toString());
        this.mToggleSwitch = new ToggleSwitch(Dict.INTERVAL.toString());
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        HBox hBox = new HBox(new Node[]{this.mPresetSplitMenuButton, spacer, this.mToggleSwitch});
        hBox.setAlignment(Pos.CENTER);
        this.setBottom((Node)hBox);
        this.setCenter((Node)this.mDatePane);
        this.mPresetSplitMenuButton.disableProperty().bind((ObservableValue)this.mToggleSwitch.selectedProperty().not());
    }

    private LocalDate getProperMax(LocalDate localDate) {
        return DateHelper.getMin((LocalDate)localDate, (LocalDate)this.mManager.getMaxDate());
    }

    private LocalDate getProperMin(LocalDate localDate) {
        return DateHelper.getMax((LocalDate)localDate, (LocalDate)this.mManager.getMinDate());
    }

    private void initListeners() {
        ChangeListener minMaxChangeListener = (ov, t, t1) -> {
            this.mDatePane.setMinMaxDate(this.mManager.getMinDate(), this.mManager.getMaxDate());
            try {
                this.setDisable(this.mManager.getMinDate().equals(LocalDate.of(1900, 1, 1)) && this.mManager.getMaxDate().equals(LocalDate.of(2099, 12, 31)));
            }
            catch (Exception e) {
                this.setDisable(true);
            }
            this.refreshTitle();
        };
        this.mManager.minDateProperty().addListener(minMaxChangeListener);
        this.mManager.maxDateProperty().addListener(minMaxChangeListener);
        ChangeListener rangeChangeListener = (ov, t, t1) -> this.refreshTitle();
        this.mManager.lowDateProperty().addListener(rangeChangeListener);
        this.mManager.highDateProperty().addListener(rangeChangeListener);
        this.mManager.lowDateProperty().bindBidirectional((Property)this.mDatePane.getFromDatePicker().valueProperty());
        this.mManager.highDateProperty().bindBidirectional((Property)this.mDatePane.getToDatePicker().valueProperty());
        this.mToggleSwitch.selectedProperty().addListener((ov, t, t1) -> {
            this.mDatePane.setDateSelectionMode(t1 != false ? DateSelectionMode.INTERVAL : DateSelectionMode.POINT_IN_TIME);
            this.refreshTitle();
        });
        this.mPresetSplitMenuButton.setOnAction(ae -> {
            this.mToggleSwitch.setSelected(true);
            this.mManager.lowDateProperty().set((Object)this.mManager.getMinDate());
            this.mManager.highDateProperty().set((Object)this.mManager.getMaxDate());
        });
    }

    private void populatePreset(TemporalPreset temporalPreset) {
        MenuItem menuItem = new MenuItem(temporalPreset.name);
        menuItem.setOnAction(ae -> {
            this.mManager.setLowDate(this.getProperMin(temporalPreset.lowDate));
            this.mManager.setHighDate(this.getProperMax(temporalPreset.highDate));
        });
        this.mPresetSplitMenuButton.getItems().add((Object)menuItem);
    }

    private void populatePresets() {
        LocalDate now = LocalDate.now();
        this.populatePreset(new TemporalPreset("%s + 1 %s".formatted(Dict.Time.TODAY.toString(), Dict.Time.YEAR.toString().toLowerCase()), now, now.plusYears(1L)));
        this.populatePreset(new TemporalPreset("%s + 1 %s".formatted(Dict.Time.TODAY.toString(), Dict.Time.MONTH.toString().toLowerCase()), now, now.plusMonths(1L)));
        this.populatePreset(new TemporalPreset("%s + 1 %s".formatted(Dict.Time.TODAY.toString(), Dict.Time.WEEK.toString().toLowerCase()), now, now.plusWeeks(1L)));
        this.populatePreset(new TemporalPreset("%s + 1 %s".formatted(Dict.Time.TODAY.toString(), Dict.Time.DAY.toString().toLowerCase()), now, now.plusDays(1L)));
        this.mPresetSplitMenuButton.getItems().add((Object)new SeparatorMenuItem());
        this.populatePreset(new TemporalPreset(Dict.Time.TODAY.toString(), now, now));
        this.mPresetSplitMenuButton.getItems().add((Object)new SeparatorMenuItem());
        this.populatePreset(new TemporalPreset("%s - 1 %s".formatted(Dict.Time.TODAY.toString(), Dict.Time.DAY.toString().toLowerCase()), now.minusDays(1L), now));
        this.populatePreset(new TemporalPreset("%s - 1 %s".formatted(Dict.Time.TODAY.toString(), Dict.Time.WEEK.toString().toLowerCase()), now.minusWeeks(1L), now));
        this.populatePreset(new TemporalPreset("%s - 1 %s".formatted(Dict.Time.TODAY.toString(), Dict.Time.MONTH.toString().toLowerCase()), now.minusMonths(1L), now));
        this.populatePreset(new TemporalPreset("%s - 1 %s".formatted(Dict.Time.TODAY.toString(), Dict.Time.YEAR.toString().toLowerCase()), now.minusYears(1L), now));
    }

    private void refreshTitle() {
        FxHelper.runLater(() -> {
            if (this.isDisabled()) {
                this.mTitleProperty.set((Object)Dict.DATE.toString());
            } else {
                String text = null;
                switch (this.mDatePane.getDateSelectionMode()) {
                    case INTERVAL: {
                        text = "%s %s %s".formatted(this.mManager.getLowDate(), Dict.TO.toString().toLowerCase(Locale.getDefault()), this.mManager.getHighDate());
                        break;
                    }
                    case POINT_IN_TIME: {
                        text = this.mManager.getHighDate().toString();
                    }
                }
                this.mTitleProperty.set(text);
            }
        });
    }

    class TemporalPreset {
        private final LocalDate highDate;
        private final LocalDate lowDate;
        private final String name;

        public TemporalPreset(String name, LocalDate lowDate, LocalDate highDate) {
            this.name = name;
            this.lowDate = lowDate;
            this.highDate = highDate;
        }

        public String toString() {
            return this.name;
        }
    }
}

