/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.area;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import org.controlsfx.control.CheckTreeView;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.mapton.api.MArea;
import org.mapton.api.MAreaFilterManager;
import org.mapton.api.Mapton;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class AreaPane
extends BorderPane {
    private final MAreaFilterManager mAreaFilterManager = MAreaFilterManager.getInstance();

    public AreaPane() {
        this.createUI();
    }

    private void actionAdd() {
        System.out.println("add");
    }

    private void actionEdit() {
        System.out.println("edi");
    }

    private void actionRemove() {
        System.out.println("remove");
    }

    private void createUI() {
        CheckTreeView treeView = this.mAreaFilterManager.getTreeView();
        Action allAction = new Action(Dict.SELECT_ALL.toString(), actionEvent -> treeView.getCheckModel().checkAll());
        allAction.setGraphic((Node)MaterialIcon._Content.SELECT_ALL.getImageView(Mapton.getIconSizeToolBarInt()));
        allAction.disabledProperty().bind((ObservableValue)treeView.getRoot().leafProperty());
        Action clearAction = new Action(Dict.CLEAR_SELECTION.toString(), actionEvent -> treeView.getCheckModel().clearChecks());
        clearAction.setGraphic((Node)MaterialIcon._Communication.CLEAR_ALL.getImageView(Mapton.getIconSizeToolBarInt()));
        clearAction.disabledProperty().bind((ObservableValue)treeView.getRoot().leafProperty());
        Action addAction = new Action(Dict.ADD.toString(), actionEvent -> this.actionAdd());
        addAction.setGraphic((Node)MaterialIcon._Content.ADD.getImageView(Mapton.getIconSizeToolBarInt()));
        addAction.setDisabled(true);
        Action remAction = new Action(Dict.REMOVE.toString(), actionEvent -> this.actionRemove());
        remAction.setGraphic((Node)MaterialIcon._Content.REMOVE.getImageView(Mapton.getIconSizeToolBarInt()));
        remAction.setDisabled(true);
        Action editAction = new Action(Dict.EDIT.toString(), actionEvent -> this.actionEdit());
        editAction.setGraphic((Node)MaterialIcon._Editor.MODE_EDIT.getImageView(Mapton.getIconSizeToolBarInt()));
        editAction.setDisabled(true);
        this.mAreaFilterManager.selectedObjectProperty().addListener((observable, oldValue, newValue) -> {});
        List<Action> actions = Arrays.asList(allAction, clearAction, ActionUtils.ACTION_SEPARATOR, addAction, remAction, editAction, ActionUtils.ACTION_SPAN);
        ToolBar toolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)toolBar.getItems().stream(), (double)Mapton.getIconSizeToolBarInt());
        FxHelper.undecorateButtons((Stream)toolBar.getItems().stream());
        FxHelper.slimToolBar((ToolBar)toolBar);
        this.setTop((Node)toolBar);
        this.setCenter((Node)treeView);
        treeView.setCellFactory(param -> new AreaTreeCell());
    }

    class AreaTreeCell
    extends CheckBoxTreeCell<MArea> {
        private final ArrayList<Coordinate> mTreeCoordinates = new ArrayList();

        public AreaTreeCell() {
            this.createUI();
        }

        public void updateItem(MArea area, boolean empty) {
            super.updateItem((Object)area, empty);
            if (area == null || empty) {
                this.clearContent();
            } else {
                this.addContent(area);
            }
        }

        private void addContent(MArea area) {
            this.setText(area.getName());
            this.setOnMouseClicked(mouseEvent -> {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == MouseButton.PRIMARY) {
                    this.mTreeCoordinates.clear();
                    this.mergeChildren((TreeItem<MArea>)this.getTreeItem());
                    Mapton.getEngine().fitToBounds(this.mTreeCoordinates);
                }
            });
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
            this.setOnMouseClicked(null);
        }

        private void createUI() {
        }

        private void mergeChildren(TreeItem<MArea> treeItem) {
            Geometry geometry = ((MArea)treeItem.getValue()).getGeometry();
            if (treeItem.isLeaf()) {
                if (geometry != null) {
                    this.mTreeCoordinates.addAll(Arrays.asList(geometry.getCoordinates()));
                }
            } else {
                for (TreeItem childTreeItem : treeItem.getChildren()) {
                    this.mergeChildren((TreeItem<MArea>)childTreeItem);
                }
            }
        }
    }
}

