/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.bookmark;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.mapton.api.MBookmark;
import org.mapton.api.MBookmarkManager;
import org.mapton.api.MDict;
import se.trixon.almond.nbp.fx.FxDialogPanel;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class BookmarkPanel
extends FxDialogPanel {
    private BookmarkView mBookmarkView;

    public void load(MBookmark bookmark) {
        this.mBookmarkView.load(bookmark);
    }

    public void save(MBookmark bookmark) {
        this.mBookmarkView.save(bookmark);
    }

    @Override
    protected void fxConstructor() {
        this.mBookmarkView = new BookmarkView();
        this.setScene(new Scene((Parent)this.mBookmarkView));
    }

    class BookmarkView
    extends StackPane {
        private MBookmark mBookmark;
        private ComboBox<String> mCategoryComboBox;
        private ColorPicker mColorPicker;
        private TextArea mDescTextArea;
        private Spinner<Double> mLatitudeSpinner;
        private Spinner<Double> mLongitudeSpinner;
        private final MBookmarkManager mManager = MBookmarkManager.getInstance();
        private TextField mNameTextField;
        private CheckBox mPlacemarkCheckBox;
        private TextField mUrlTextField;
        private Spinner<Double> mZoomSpinner;

        public BookmarkView() {
            this.createUI();
        }

        public void load(MBookmark bookmark) {
            this.mBookmark = bookmark;
            this.mNameTextField.setText(bookmark.getName());
            this.mCategoryComboBox.getSelectionModel().select((Object)bookmark.getCategory());
            this.mDescTextArea.setText(bookmark.getDescription());
            this.mUrlTextField.setText(bookmark.getUrl());
            this.mZoomSpinner.getValueFactory().setValue((Object)bookmark.getZoom());
            this.mLatitudeSpinner.getValueFactory().setValue((Object)bookmark.getLatitude());
            this.mLongitudeSpinner.getValueFactory().setValue((Object)bookmark.getLongitude());
            this.mPlacemarkCheckBox.setSelected(bookmark.isDisplayMarker().booleanValue());
            Color color = Color.YELLOW;
            try {
                color = FxHelper.colorFromHexRGBA((String)bookmark.getColor());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mColorPicker.setValue((Object)color);
        }

        public void save(MBookmark bookmark) {
            bookmark.setName(this.mNameTextField.getText());
            bookmark.setCategory(this.mCategoryComboBox.getEditor().getText().trim());
            bookmark.setDescription(StringUtils.defaultString((String)this.mDescTextArea.getText()));
            bookmark.setUrl(StringUtils.defaultString((String)this.mUrlTextField.getText()));
            bookmark.setZoom((Double)this.mZoomSpinner.getValue());
            bookmark.setLatitude((Double)this.mLatitudeSpinner.getValue());
            bookmark.setLongitude((Double)this.mLongitudeSpinner.getValue());
            bookmark.setDisplayMarker(Boolean.valueOf(this.mPlacemarkCheckBox.isSelected()));
            bookmark.setColor(FxHelper.colorToHexRGB((Color)((Color)this.mColorPicker.getValue())));
        }

        private void createUI() {
            this.mNameTextField = new TextField();
            this.mCategoryComboBox = new ComboBox();
            this.mDescTextArea = new TextArea();
            this.mUrlTextField = new TextField();
            this.mZoomSpinner = new Spinner(0.0, 1.0, 0.25, 0.1);
            this.mLatitudeSpinner = new Spinner(-90.0, 90.0, 0.0, 1.0E-6);
            this.mLongitudeSpinner = new Spinner(-180.0, 180.0, 0.0, 1.0E-6);
            this.mColorPicker = new ColorPicker();
            this.mCategoryComboBox.prefWidthProperty().bind((ObservableValue)this.mNameTextField.widthProperty());
            this.mCategoryComboBox.setEditable(true);
            this.mCategoryComboBox.getItems().setAll((Collection)this.mManager.getCategories());
            StringConverter<Double> converter = new StringConverter<Double>(){
                private final DecimalFormat mDecimalFormat = new DecimalFormat("#.######");

                public Double fromString(String value) {
                    try {
                        if (value == null) {
                            return null;
                        }
                        if ((value = value.trim()).length() < 1) {
                            return null;
                        }
                        return this.mDecimalFormat.parse(value).doubleValue();
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                public String toString(Double value) {
                    if (value == null) {
                        return "";
                    }
                    return this.mDecimalFormat.format(value);
                }
            };
            this.mZoomSpinner.getValueFactory().setConverter((StringConverter)converter);
            this.mLatitudeSpinner.getValueFactory().setConverter((StringConverter)converter);
            this.mLongitudeSpinner.getValueFactory().setConverter((StringConverter)converter);
            this.mPlacemarkCheckBox = new CheckBox(MDict.DISPLAY_PLACEMARK.toString());
            this.mZoomSpinner.setEditable(true);
            this.mLatitudeSpinner.setEditable(true);
            this.mLongitudeSpinner.setEditable(true);
            FxHelper.autoCommitSpinners((Spinner[])new Spinner[]{this.mZoomSpinner, this.mLatitudeSpinner, this.mLongitudeSpinner});
            this.mDescTextArea.setPrefHeight(20.0);
            Label nameLabel = new Label(Dict.NAME.toString());
            Label descLabel = new Label(Dict.DESCRIPTION.toString());
            Label categoryLabel = new Label(Dict.CATEGORY.toString());
            Label colorLabel = new Label(Dict.COLOR.toString());
            Label zoomLabel = new Label(Dict.ZOOM.toString());
            Label latLabel = new Label(Dict.LATITUDE.toString());
            Label lonLabel = new Label(Dict.LONGITUDE.toString());
            Label urlLabel = new Label("URL");
            VBox box = new VBox(new Node[]{nameLabel, this.mNameTextField, categoryLabel, this.mCategoryComboBox, descLabel, this.mDescTextArea, urlLabel, this.mUrlTextField, colorLabel, this.mColorPicker, zoomLabel, this.mZoomSpinner, latLabel, this.mLatitudeSpinner, lonLabel, this.mLongitudeSpinner, this.mPlacemarkCheckBox});
            this.initValidation();
            box.setPadding(new Insets(8.0, 16.0, 0.0, 16.0));
            VBox.setVgrow((Node)this.mDescTextArea, (Priority)Priority.ALWAYS);
            Insets topInsets = new Insets(8.0, 0.0, 8.0, 0.0);
            VBox.setMargin((Node)descLabel, (Insets)topInsets);
            VBox.setMargin((Node)categoryLabel, (Insets)topInsets);
            VBox.setMargin((Node)zoomLabel, (Insets)topInsets);
            VBox.setMargin((Node)latLabel, (Insets)topInsets);
            VBox.setMargin((Node)lonLabel, (Insets)topInsets);
            VBox.setMargin((Node)colorLabel, (Insets)topInsets);
            VBox.setMargin((Node)this.mPlacemarkCheckBox, (Insets)topInsets);
            this.getChildren().setAll((Object[])new Node[]{box});
        }

        private void initValidation() {
            String text_is_required = "Text is required";
            ValidationSupport validationSupport = new ValidationSupport();
            Validator emptyValidator = Validator.createEmptyValidator((String)"Text is required");
            validationSupport.registerValidator((Control)this.mNameTextField, true, emptyValidator);
            Validator uniqueValidator = Validator.createPredicateValidator(s -> true, (String)"The combination of name and category has to be unique");
            validationSupport.registerValidator((Control)this.mCategoryComboBox.getEditor(), false, uniqueValidator);
            validationSupport.validationResultProperty().addListener((observable, oldValue, newValue) -> {
                String name = this.mNameTextField.getText().trim();
                String category = this.mCategoryComboBox.getEditor().getText().trim();
                BookmarkPanel.this.mNotifyDescriptor.setValid(validationSupport.isInvalid() == false && !this.mManager.exists((Object)this.mBookmark.getId(), name, category));
            });
            validationSupport.initInitialDecoration();
        }
    }
}

