/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.bookmark;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.textfield.TextFields;
import org.mapton.api.MBookmark;
import org.mapton.api.MBookmarkManager;
import org.mapton.api.MContextMenuItem;
import org.mapton.api.MDict;
import org.mapton.api.Mapton;
import org.mapton.core.api.BookmarkEditor;
import org.mapton.core.ui.bookmark.FileExportAction;
import org.mapton.core.ui.bookmark.FileImportAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class BookmarksView
extends BorderPane {
    private final Map<String, TreeItem<MBookmark>> mBookmarkParents = new TreeMap<String, TreeItem<MBookmark>>();
    private final BookmarkEditor mBookmarkEditor;
    private TextField mFilterTextField;
    private final MBookmarkManager mManager = MBookmarkManager.getInstance();
    private final PopOver mPopOver;
    private final Preferences mPreferences = NbPreferences.forModule(BookmarksView.class).node("expanded_state");
    private final TreeView<MBookmark> mTreeView = new TreeView();

    public BookmarksView(PopOver popOver) {
        this.mPopOver = popOver;
        this.mBookmarkEditor = new BookmarkEditor();
        this.createUI();
        this.mManager.dbLoad(this.mFilterTextField.getText(), true);
        this.populate();
        this.addListeners();
    }

    private void addListeners() {
        this.mFilterTextField.textProperty().addListener((observable, oldValue, newValue) -> this.mManager.dbLoad(newValue, true));
        this.mManager.getItems().addListener(c -> this.populate());
    }

    private void bookmarkEdit() {
        MBookmark bookmark = this.getSelectedBookmark();
        if (bookmark != null) {
            if (bookmark.isCategory().booleanValue()) {
                this.mBookmarkEditor.editCategory(bookmark.getCategory());
            } else {
                this.mBookmarkEditor.editBookmark(bookmark);
            }
        }
    }

    private void bookmarkGoTo(MBookmark bookmark) {
        try {
            this.mManager.goTo(bookmark);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassNotFoundException | SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void createUI() {
        this.mFilterTextField = TextFields.createClearableTextField();
        this.mFilterTextField.setPromptText(Dict.BOOKMARKS_SEARCH.toString());
        this.mFilterTextField.setMinWidth(20.0);
        this.mTreeView.setShowRoot(false);
        this.mTreeView.setCellFactory(param -> new BookmarkTreeCell());
        List<Action> actions = Arrays.asList(new FileImportAction(this.mPopOver).getAction((Node)this), new FileExportAction(this.mPopOver).getAction((Node)this));
        ToolBar toolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)toolBar.getItems().stream(), (double)Mapton.getIconSizeToolBarInt());
        FxHelper.undecorateButtons((Stream)toolBar.getItems().stream());
        BorderPane topBorderPane = new BorderPane((Node)this.mFilterTextField);
        topBorderPane.setRight((Node)toolBar);
        toolBar.setMinWidth((double)Mapton.getIconSizeToolBarInt() * 3.5);
        FxHelper.slimToolBar((ToolBar)toolBar);
        this.setTop((Node)topBorderPane);
        this.setCenter((Node)this.mTreeView);
    }

    private TreeItem<MBookmark> getParent(TreeItem<MBookmark> parent, String category) {
        String[] categorySegments = StringUtils.split((String)category, (String)"/");
        StringBuilder sb = new StringBuilder();
        for (String segment : categorySegments) {
            sb.append(segment);
            String path = sb.toString();
            if (this.mBookmarkParents.containsKey(path)) {
                parent = this.mBookmarkParents.get(path);
            } else {
                MBookmark bookmark = new MBookmark();
                bookmark.setCategory(path);
                bookmark.setName(segment);
                ObservableList observableList = parent.getChildren();
                parent = this.mBookmarkParents.computeIfAbsent(sb.toString(), k -> new TreeItem((Object)bookmark));
                observableList.add((Object)parent);
            }
            sb.append("/");
        }
        return parent;
    }

    private MBookmark getSelectedBookmark() {
        TreeItem item = (TreeItem)this.mTreeView.getSelectionModel().getSelectedItem();
        return item != null ? (MBookmark)item.getValue() : null;
    }

    private void populate() {
        MBookmark rootMark = new MBookmark();
        rootMark.setName("");
        TreeItem root = new TreeItem((Object)rootMark);
        TreeMap<String, TreeItem> bookmarkParents = new TreeMap<String, TreeItem>();
        for (MBookmark bookmark : this.mManager.getItems()) {
            TreeItem bookmarkTreeItem = new TreeItem((Object)bookmark);
            String category = bookmark.getCategory();
            TreeItem parent = bookmarkParents.computeIfAbsent(category, k -> this.getParent((TreeItem<MBookmark>)root, category));
            parent.getChildren().add((Object)bookmarkTreeItem);
        }
        this.mBookmarkParents.clear();
        this.mBookmarkParents.putAll(this.mBookmarkParents);
        this.postPopulate((TreeItem<MBookmark>)root, "");
        this.mTreeView.setRoot(root);
    }

    private void postPopulate(TreeItem<MBookmark> treeItem, String level) {
        MBookmark value = (MBookmark)treeItem.getValue();
        String path = "%s/%s".formatted(value.getCategory(), value.getName());
        treeItem.setExpanded(this.mPreferences.getBoolean(path, false));
        treeItem.expandedProperty().addListener((observable, oldValue, newValue) -> this.mPreferences.putBoolean(path, (boolean)newValue));
        Comparator c1 = (o1, o2) -> Boolean.compare(o1.getChildren().isEmpty(), o2.getChildren().isEmpty());
        Comparator c2 = (o1, o2) -> ((MBookmark)o1.getValue()).getName().compareTo(((MBookmark)o2.getValue()).getName());
        treeItem.getChildren().sort(c1.thenComparing(c2));
        for (TreeItem childTreeItem : treeItem.getChildren()) {
            this.postPopulate((TreeItem<MBookmark>)childTreeItem, level + "-");
        }
    }

    class BookmarkTreeCell
    extends TreeCell<MBookmark> {
        private Menu mContextCopyMenu;
        private Menu mContextOpenMenu;

        public BookmarkTreeCell() {
            this.createUI();
        }

        protected void updateItem(MBookmark bookmark, boolean empty) {
            super.updateItem((Object)bookmark, empty);
            if (bookmark == null || empty) {
                this.clearContent();
            } else {
                this.addContent(bookmark);
            }
        }

        private void addContent(MBookmark bookmark) {
            this.setText(bookmark.getName());
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
        }

        private void createUI() {
            Color color = Mapton.options().getIconColorForBackground();
            Action editAction = new Action(Dict.EDIT.toString(), event -> BookmarksView.this.bookmarkEdit());
            editAction.setGraphic((Node)MaterialIcon._Content.CREATE.getImageView(Mapton.getIconSizeContextMenu(), color));
            Action editColorAction = new Action(Dict.COLOR.toString(), event -> BookmarksView.this.mBookmarkEditor.editColor(BookmarksView.this.getSelectedBookmark().getCategory()));
            editColorAction.setGraphic((Node)MaterialIcon._Image.COLORIZE.getImageView(Mapton.getIconSizeContextMenu(), color));
            Action editZoomAction = new Action(Dict.ZOOM.toString(), event -> BookmarksView.this.mBookmarkEditor.editZoom(BookmarksView.this.getSelectedBookmark().getCategory()));
            editZoomAction.setGraphic((Node)MaterialIcon._Editor.FORMAT_SIZE.getImageView(Mapton.getIconSizeContextMenu(), color));
            Action zoomExtentAction = new Action(Dict.ZOOM_EXTENTS.toString(), event -> Mapton.getEngine().fitToBounds(BookmarksView.this.mManager.getExtents(BookmarksView.this.getSelectedBookmark().getCategory())));
            Action removeAction = new Action(Dict.REMOVE.toString(), event -> BookmarksView.this.mBookmarkEditor.remove(BookmarksView.this.getSelectedBookmark()));
            Action removeAllAction = new Action(Dict.REMOVE_ALL.toString(), event -> BookmarksView.this.mBookmarkEditor.removeAll());
            List<Action> actions = Arrays.asList(editAction, editColorAction, editZoomAction, zoomExtentAction, ActionUtils.ACTION_SEPARATOR, removeAction, removeAllAction);
            ContextMenu contextMenu = ActionUtils.createContextMenu(actions);
            this.mContextCopyMenu = new Menu(MDict.COPY_LOCATION.toString());
            this.mContextOpenMenu = new Menu(MDict.OPEN_LOCATION.toString());
            contextMenu.getItems().add(4, (Object)this.mContextOpenMenu);
            contextMenu.getItems().add(4, (Object)this.mContextCopyMenu);
            this.setOnMousePressed(mouseEvent -> {
                this.getScene().getWindow().requestFocus();
                BookmarksView.this.mTreeView.requestFocus();
                MBookmark bookmark = (MBookmark)this.getItem();
                if (bookmark != null) {
                    Mapton.getEngine().setLockedLatitude(bookmark.getLatitude());
                    Mapton.getEngine().setLockedLongitude(bookmark.getLongitude());
                    if (mouseEvent.isSecondaryButtonDown()) {
                        this.mContextCopyMenu.setDisable(bookmark.isCategory().booleanValue());
                        this.mContextOpenMenu.setDisable(bookmark.isCategory().booleanValue());
                        editColorAction.setDisabled(bookmark.isCategory() == false);
                        editZoomAction.setDisabled(bookmark.isCategory() == false);
                        zoomExtentAction.setDisabled(bookmark.isCategory() == false);
                        if (!bookmark.isCategory().booleanValue()) {
                            Mapton.getEngine().setLatitude(bookmark.getLatitude().doubleValue());
                            Mapton.getEngine().setLongitude(bookmark.getLongitude().doubleValue());
                        }
                        contextMenu.show((Node)this, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                    } else if (mouseEvent.isPrimaryButtonDown() && mouseEvent.getClickCount() == 2) {
                        contextMenu.hide();
                        BookmarksView.this.bookmarkGoTo(bookmark);
                    }
                }
            });
            Lookup.getDefault().lookupResult(MContextMenuItem.class).addLookupListener(ev -> this.populateContextProviders());
            this.populateContextProviders();
        }

        private void populateContextProviders() {
            this.mContextCopyMenu.getItems().clear();
            this.mContextOpenMenu.getItems().clear();
            for (MContextMenuItem provider : Lookup.getDefault().lookupAll(MContextMenuItem.class)) {
                MenuItem item = new MenuItem(provider.getName());
                switch (provider.getType()) {
                    case COPY: {
                        this.mContextCopyMenu.getItems().add((Object)item);
                        item.setOnAction(event -> {
                            String s = provider.getUrl();
                            Mapton.getLog().v("Open location", s);
                            SystemHelper.copyToClipboard((String)s);
                        });
                        break;
                    }
                    case OPEN: {
                        this.mContextOpenMenu.getItems().add((Object)item);
                        item.setOnAction(event -> {
                            String s = provider.getUrl();
                            Mapton.getLog().v("Copy location", s);
                            SystemHelper.desktopBrowse((String)s);
                        });
                    }
                }
            }
            this.mContextCopyMenu.getItems().sorted((o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText()));
            this.mContextCopyMenu.setVisible(!this.mContextCopyMenu.getItems().isEmpty());
            this.mContextOpenMenu.getItems().sorted((o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText()));
            this.mContextOpenMenu.setVisible(!this.mContextOpenMenu.getItems().isEmpty());
        }
    }
}

