/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.bookmark;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.KmlFactory;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import javafx.scene.Node;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.action.Action;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MBookmark;
import org.mapton.api.MKmlCreator;
import org.mapton.api.MNotificationIcons;
import org.mapton.api.Mapton;
import org.mapton.core.ui.bookmark.FileAction;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxActionSwing;
import se.trixon.almond.util.icons.material.MaterialIcon;
import se.trixon.almond.util.io.Geo;
import se.trixon.almond.util.io.GeoHeader;
import se.trixon.almond.util.io.GeoPoint;
import se.trixon.almond.util.swing.FileHelper;

public class FileExportAction
extends FileAction {
    private File mFile;

    public FileExportAction(PopOver popOver) {
        super(popOver);
    }

    @Override
    public Action getAction(Node owner) {
        FxActionSwing action = new FxActionSwing(Dict.EXPORT.toString(), () -> {
            this.hidePopOver();
            String dialogTitle = "%s %s".formatted(Dict.EXPORT.toString(), this.mTitle.toLowerCase());
            HashMap extensionFilters = FileChooserHelper.getExtensionFilters();
            JFileChooser fileChooser = new FileChooserBuilder(FileExportAction.class).addFileFilter((FileFilter)extensionFilters.get("csv")).addFileFilter((FileFilter)extensionFilters.get("geo")).addFileFilter((FileFilter)extensionFilters.get("json")).addFileFilter((FileFilter)extensionFilters.get("kml")).setAcceptAllFileFilterUsed(false).setDefaultWorkingDirectory(FileHelper.getDefaultDirectory()).setFileFilter((FileFilter)extensionFilters.get("csv")).setFilesOnly(true).setSelectionApprover(FileChooserHelper.getFileExistSelectionApprover((Component)Almond.getFrame())).setTitle(dialogTitle).createFileChooser();
            if (fileChooser.showSaveDialog(Almond.getFrame()) == 0) {
                new Thread(() -> {
                    this.mFile = FileChooserHelper.getFileWithProperExt((JFileChooser)fileChooser);
                    try {
                        switch (FilenameUtils.getExtension((String)this.mFile.getName())) {
                            case "csv": {
                                new CsvExporter();
                                break;
                            }
                            case "json": {
                                new JsonExporter();
                                break;
                            }
                            case "geo": {
                                new GeoExporter();
                                break;
                            }
                            case "kml": {
                                new KmlExporter();
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        NotificationDisplayer.getDefault().notify(Dict.OPERATION_COMPLETED.toString(), (Icon)MNotificationIcons.getInformationIcon(), dialogTitle, null, NotificationDisplayer.Priority.LOW);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }, this.getClass().getCanonicalName()).start();
            }
        });
        action.setGraphic((Node)MaterialIcon._Content.SAVE.getImageView(Mapton.getIconSizeToolBarInt()));
        return action;
    }

    private class CsvExporter {
        public CsvExporter() throws IOException {
            StringWriter stringWriter = new StringWriter();
            CSVPrinter printer = CSVFormat.DEFAULT.withCommentMarker('#').withDelimiter(';').withHeader(new String[]{"category", "name", "description", "url", "color", "latitude", "longitude", "zoom", "display_marker"}).print((Appendable)stringWriter);
            for (MBookmark bookmark : FileExportAction.this.mManager.getItems()) {
                printer.printRecord(new Object[]{bookmark.getCategory(), bookmark.getName(), bookmark.getDescription(), bookmark.getUrl(), bookmark.getColor(), bookmark.getLatitude(), bookmark.getLongitude(), bookmark.getZoom(), bookmark.isDisplayMarker() != false ? "1" : "0"});
            }
            FileUtils.writeStringToFile((File)FileExportAction.this.mFile, (String)stringWriter.toString(), (String)"utf-8");
        }
    }

    private class JsonExporter {
        public JsonExporter() throws IOException {
            Gson gson = new GsonBuilder().setVersion(1.0).setPrettyPrinting().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
            FileUtils.write((File)FileExportAction.this.mFile, (CharSequence)gson.toJson((Object)FileExportAction.this.mManager.getItems()), (String)"utf-8");
        }
    }

    private class GeoExporter {
        public GeoExporter() throws IOException {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("Application", "Mapton");
            map.put("Author", SystemHelper.getUserName());
            map.put("Created", FastDateFormat.getInstance((String)"yyyy-MM-dd HH.mm.ss").format(new Date()));
            Geo geo = new Geo(new GeoHeader(map));
            for (MBookmark bookmark : FileExportAction.this.mManager.getItems()) {
                GeoPoint point = new GeoPoint();
                point.setPointId(bookmark.getName());
                point.setRemark(bookmark.getCategory());
                point.setX(bookmark.getLatitude());
                point.setY(bookmark.getLongitude());
                point.setZ(Double.valueOf(0.0));
                geo.addPoint(point);
            }
            geo.write(FileExportAction.this.mFile);
        }
    }

    private class KmlExporter
    extends MKmlCreator {
        private final TreeMap<String, Folder> mCategories = new TreeMap();

        public KmlExporter() throws IOException {
            this.mDocument.setName("Mapton %s".formatted(Dict.BOOKMARKS.toString()));
            FileExportAction.this.mManager.getItems().forEach(item -> {
                Placemark placemark = KmlFactory.createPlacemark().withName(item.getName()).withDescription(item.getDescription()).withOpen(Boolean.TRUE);
                placemark.createAndSetPoint().addToCoordinates(item.getLongitude().doubleValue(), item.getLatitude().doubleValue());
                String key = (String)StringUtils.defaultIfBlank((CharSequence)item.getCategory(), (CharSequence)"---");
                this.mCategories.computeIfAbsent(key, k -> new Folder().withName(key)).addToFeature((Feature)placemark);
            });
            this.mCategories.values().forEach(folder -> this.mDocument.addToFeature((Feature)folder));
            this.save(FileExportAction.this.mFile);
        }
    }
}

