/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.bookmark;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.scene.Node;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.action.Action;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MBookmark;
import org.mapton.api.MNotificationIcons;
import org.mapton.api.Mapton;
import org.mapton.core.ui.bookmark.FileAction;
import org.mapton.core.ui.bookmark.FileExportAction;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.MathHelper;
import se.trixon.almond.util.fx.FxActionSwing;
import se.trixon.almond.util.icons.material.MaterialIcon;
import se.trixon.almond.util.io.Geo;
import se.trixon.almond.util.io.GeoPoint;
import se.trixon.almond.util.swing.FileHelper;

public class FileImportAction
extends FileAction {
    private File mFile;
    private int mErrors;
    private int mImports;

    public FileImportAction(PopOver popOver) {
        super(popOver);
    }

    @Override
    public Action getAction(Node owner) {
        FxActionSwing action = new FxActionSwing(Dict.IMPORT.toString(), () -> {
            this.hidePopOver();
            String dialogTitle = "%s %s".formatted(Dict.IMPORT.toString(), this.mTitle.toLowerCase());
            HashMap extensionFilters = FileChooserHelper.getExtensionFilters();
            JFileChooser fileChooser = new FileChooserBuilder(FileExportAction.class).addFileFilter((FileFilter)extensionFilters.get("csv")).addFileFilter((FileFilter)extensionFilters.get("geo")).addFileFilter((FileFilter)extensionFilters.get("json")).setDefaultWorkingDirectory(FileHelper.getDefaultDirectory()).setFileFilter((FileFilter)extensionFilters.get("csv")).setFilesOnly(true).setTitle(dialogTitle).setSelectionApprover(FileChooserHelper.getFileExistOpenSelectionApprover((Component)Almond.getFrame())).createFileChooser();
            if (fileChooser.showOpenDialog(Almond.getFrame()) == 0) {
                new Thread(() -> {
                    this.mFile = fileChooser.getSelectedFile();
                    this.mImports = 0;
                    this.mErrors = 0;
                    try {
                        switch (FilenameUtils.getExtension((String)this.mFile.getName())) {
                            case "csv": {
                                this.importCsv();
                                break;
                            }
                            case "geo": {
                                this.importGeo();
                                break;
                            }
                            case "json": {
                                this.importJson();
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        if (this.mImports + this.mErrors > 0) {
                            NotificationDisplayer.getDefault().notify(Dict.OPERATION_COMPLETED.toString(), (Icon)MNotificationIcons.getInformationIcon(), dialogTitle, null, NotificationDisplayer.Priority.LOW);
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }, this.getClass().getCanonicalName()).start();
            }
        });
        action.setGraphic((Node)MaterialIcon._File.FOLDER_OPEN.getImageView(Mapton.getIconSizeToolBarInt()));
        return action;
    }

    private String getOrDefault(CSVRecord record, String key, String defaultValue) {
        if (record.isSet(key)) {
            return record.get(key);
        }
        return defaultValue;
    }

    private void importCsv() throws IOException {
        CharSequence[] requiredColumns = new String[]{"name", "latitude", "longitude"};
        try (CSVParser csvRecords = CSVParser.parse((File)this.mFile, (Charset)Charset.forName("utf-8"), (CSVFormat)CSVFormat.DEFAULT.builder().setHeader(new String[0]).setSkipHeaderRecord(true).setDelimiter(';').build());){
            String default_zoom = "0.85";
            if (this.isValidCsv(csvRecords, (String[])requiredColumns)) {
                ArrayList<MBookmark> bookmarks = new ArrayList<MBookmark>();
                for (CSVRecord csvRecord : csvRecords) {
                    String category = this.getOrDefault(csvRecord, "category", Dict.DEFAULT.toString());
                    String description = this.getOrDefault(csvRecord, "description", "");
                    String url = this.getOrDefault(csvRecord, "url", "");
                    String color = this.getOrDefault(csvRecord, "color", "FFFF00");
                    String displayMarker = this.getOrDefault(csvRecord, "display_marker", "1");
                    String zoomString = this.getOrDefault(csvRecord, "zoom", default_zoom);
                    if (!NumberUtils.isCreatable((String)zoomString)) {
                        zoomString = default_zoom;
                    }
                    Double lat = MathHelper.convertStringToDouble((String)csvRecord.get("latitude"));
                    Double lon = MathHelper.convertStringToDouble((String)csvRecord.get("longitude"));
                    Double zoom = MathHelper.convertStringToDouble((String)zoomString);
                    MBookmark bookmark = new MBookmark();
                    bookmark.setCategory(category);
                    bookmark.setName(csvRecord.get("name"));
                    bookmark.setDescription(description);
                    bookmark.setUrl(url);
                    bookmark.setColor(color);
                    bookmark.setDisplayMarker(Boolean.valueOf(displayMarker.equalsIgnoreCase("1")));
                    bookmark.setLatitude(lat);
                    bookmark.setLongitude(lon);
                    bookmark.setZoom(zoom);
                    bookmarks.add(bookmark);
                }
                Point result = this.mManager.dbInsert(bookmarks);
                this.mImports = result.x;
                this.mErrors = result.y;
            } else {
                String message = this.mBundle.getString("bookmark_import_error_csv_message").formatted(String.join((CharSequence)"\n \u25b6 ", requiredColumns));
                NotificationDisplayer.getDefault().notify(this.mBundle.getString("bookmark_import_error_csv_title"), (Icon)MNotificationIcons.getErrorIcon(), message, null, NotificationDisplayer.Priority.HIGH);
            }
        }
    }

    private void importGeo() throws IOException {
        Geo geo = new Geo();
        geo.read(this.mFile);
        ArrayList<MBookmark> bookmarks = new ArrayList<MBookmark>();
        for (GeoPoint geoPoint : geo.getPoints()) {
            MBookmark bookmark = new MBookmark();
            bookmark.setName(geoPoint.getPointId());
            bookmark.setCategory(geoPoint.getRemark());
            bookmark.setLatitude(geoPoint.getX());
            bookmark.setLongitude(geoPoint.getY());
            bookmark.setZoom(Double.valueOf(0.999));
            bookmarks.add(bookmark);
        }
        Point result = this.mManager.dbInsert(bookmarks);
        this.mImports = result.x;
        this.mErrors = result.y;
    }

    private void importJson() throws IOException {
        Gson gson = new GsonBuilder().setVersion(1.0).setPrettyPrinting().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
        String json = FileUtils.readFileToString((File)this.mFile, (String)"UTF-8");
        ArrayList bookmarks = (ArrayList)gson.fromJson(json, new TypeToken<ArrayList<MBookmark>>(){}.getType());
        Point result = this.mManager.dbInsert(bookmarks);
        this.mImports = result.x;
        this.mErrors = result.y;
    }

    private boolean isValidCsv(CSVParser records, String[] columns) {
        for (String column : columns) {
            if (records.getHeaderMap().containsKey(column)) continue;
            return false;
        }
        return true;
    }
}

