/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.commandbox;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.prefs.Preferences;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.textfield.TextFields;
import org.mapton.api.MCommandBoxItem;
import org.mapton.api.Mapton;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.StringHelper;
import se.trixon.almond.util.SystemHelper;

public class CommandBoxView
extends BorderPane {
    private final Map<Action, String> mActionParents = new HashMap<Action, String>();
    private TextField mFilterTextField;
    private long mLatestFocus;
    private final Preferences mPreferences = NbPreferences.forModule(CommandBoxView.class).node("runbox_expanded_state");
    private final Map<String, TreeItem<Action>> mItemParents = new ConcurrentSkipListMap<String, TreeItem<Action>>();
    private final ArrayList<MCommandBoxItem> mItems = new ArrayList();
    private final TreeView<Action> mTreeView = new TreeView();

    public CommandBoxView() {
        this.createUI();
        this.initListeners();
        this.initTools();
        this.populate();
    }

    private void createUI() {
        this.mFilterTextField = TextFields.createClearableTextField();
        this.mFilterTextField.setPromptText(Dict.SEARCH.toString());
        this.mTreeView.setShowRoot(false);
        this.mTreeView.setCellFactory(param -> new ActionTreeCell());
        this.setTop((Node)this.mFilterTextField);
        this.setCenter((Node)this.mTreeView);
    }

    private TreeItem<Action> getParent(TreeItem<Action> parent, String category) {
        String[] categorySegments = StringUtils.split((String)category, (String)"/");
        StringBuilder sb = new StringBuilder();
        for (String segment : categorySegments) {
            sb.append(segment);
            String path = sb.toString();
            if (this.mItemParents.containsKey(path)) {
                parent = this.mItemParents.get(path);
            } else {
                Action action = new Action(segment, actionEvent -> {});
                ObservableList observableList = parent.getChildren();
                parent = this.mItemParents.computeIfAbsent(sb.toString(), k -> new TreeItem((Object)action));
                observableList.add((Object)parent);
            }
            sb.append("/");
        }
        return parent;
    }

    private void initListeners() {
        this.mFilterTextField.textProperty().addListener((observable, oldValue, newValue) -> this.populate());
        this.mTreeView.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.mLatestFocus = System.currentTimeMillis();
        });
        this.mTreeView.setOnKeyPressed(event -> {
            TreeItem selectedItem = (TreeItem)this.mTreeView.getSelectionModel().getSelectedItem();
            if (selectedItem != null && event.getCode() == KeyCode.ENTER) {
                if (selectedItem.getChildren().isEmpty()) {
                    Mapton.getGlobalState().send("map_tool.started", (Object)event);
                }
                ((Action)((TreeItem)this.mTreeView.getSelectionModel().getSelectedItem()).getValue()).handle(null);
            }
        });
        Lookup.getDefault().lookupResult(MCommandBoxItem.class).addLookupListener(event -> this.initTools());
        Mapton.getGlobalState().addListener(evt -> Almond.openAndActivateTopComponent((String)evt.getValue()), new String[]{"map.layer.fastopen_tool"});
    }

    private void initTools() {
        this.mItems.clear();
        Lookup.getDefault().lookupAll(MCommandBoxItem.class).forEach(tool -> this.mItems.add((MCommandBoxItem)tool));
    }

    private void populate() {
        this.mItemParents.clear();
        Action rootMark = new Action("");
        TreeItem root = new TreeItem((Object)rootMark);
        for (MCommandBoxItem item : this.mItems) {
            this.mActionParents.put(item.getAction(), item.getParent());
            String filter = this.mFilterTextField.getText();
            boolean validFilter = StringHelper.matchesSimpleGlob((String)item.getParent(), (String)filter, (boolean)true, (boolean)true) || StringHelper.matchesSimpleGlob((String)item.getAction().getText(), (String)filter, (boolean)true, (boolean)true);
            if (!validFilter) continue;
            TreeItem actionTreeItem = new TreeItem((Object)item.getAction());
            String category = StringUtils.defaultString((String)item.getParent());
            TreeItem parent = this.mItemParents.computeIfAbsent(category, k -> this.getParent((TreeItem<Action>)root, category));
            parent.getChildren().add((Object)actionTreeItem);
        }
        this.postPopulate((TreeItem<Action>)root, "");
        this.mTreeView.setRoot(root);
    }

    private void postPopulate(TreeItem<Action> treeItem, String level) {
        Action value = (Action)treeItem.getValue();
        String path = "%s/%s".formatted(this.mActionParents.get(value), value.getText());
        treeItem.setExpanded(this.mPreferences.getBoolean(path, false));
        treeItem.expandedProperty().addListener((observable, oldValue, newValue) -> this.mPreferences.putBoolean(path, (boolean)newValue));
        Comparator c1 = (o1, o2) -> Boolean.compare(o1.getChildren().isEmpty(), o2.getChildren().isEmpty());
        Comparator c2 = (o1, o2) -> ((Action)o1.getValue()).getText().compareTo(((Action)o2.getValue()).getText());
        treeItem.getChildren().sort(c1.thenComparing(c2));
        for (TreeItem childTreeItem : treeItem.getChildren()) {
            this.postPopulate((TreeItem<Action>)childTreeItem, level + "-");
        }
    }

    class ActionTreeCell
    extends TreeCell<Action> {
        public ActionTreeCell() {
            this.createUI();
        }

        protected void updateItem(Action action, boolean empty) {
            super.updateItem((Object)action, empty);
            if (action == null || empty) {
                this.clearContent();
            } else {
                this.addContent(action);
            }
        }

        private void addContent(Action action) {
            String text = action.getText();
            if (StringUtils.endsWith((CharSequence)text, (CharSequence)")<")) {
                this.setText(StringUtils.substringBefore((String)text, (String)" ("));
                this.setTooltip(new Tooltip(StringUtils.removeEnd((String)text, (String)"<")));
            } else {
                this.setText(text);
            }
            this.setGraphic(action.getGraphic());
            this.setOnMouseClicked(event -> {
                int clicksToSubtract = SystemHelper.age((long)CommandBoxView.this.mLatestFocus) < 1000L ? 1 : 0;
                int clicks = event.getClickCount() - clicksToSubtract;
                if (clicks == 2 && event.getButton() == MouseButton.PRIMARY) {
                    if (this.getChildren().isEmpty()) {
                        Mapton.getGlobalState().send("map_tool.started", (Object)event);
                    }
                    action.handle(null);
                }
            });
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
        }

        private void createUI() {
        }
    }
}

