/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.datasources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.api.MDataSource;
import org.mapton.api.Mapton;
import org.mapton.api.ui.DataSourceTab;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class DataSourcesPane
extends BorderPane {
    private TabPane mTabPane;
    private ToolBar mToolBar;
    private DataSourceTab mWmsSourceTab;
    private DataSourceTab mWmsStyleTab;

    public DataSourcesPane() {
        this.createUI();
        this.init();
    }

    void save() {
        Platform.runLater(() -> {
            this.mWmsSourceTab.save();
            this.mWmsStyleTab.save();
        });
    }

    private void apply() {
        this.save();
    }

    private void createUI() {
        this.initToolBar();
        String[] wmsExts = new String[]{"json"};
        this.mWmsSourceTab = new DataSourceTab("WMS " + Dict.SOURCE.toString(), "data_sources.wms.sources", wmsExts);
        this.mWmsStyleTab = new DataSourceTab("WMS " + Dict.STYLE.toString(), "data_sources.wms.styles", wmsExts);
        this.mTabPane = new TabPane(new Tab[]{this.mWmsSourceTab, this.mWmsStyleTab});
        for (Tab tab : this.mTabPane.getTabs()) {
            tab.setClosable(false);
        }
        this.setCenter((Node)this.mTabPane);
    }

    private void init() {
        this.mWmsSourceTab.load(MDataSource.getDefaultSources());
        this.mWmsStyleTab.load(MDataSource.getDefaultStyles());
        this.apply();
    }

    private void initToolBar() {
        Action applyAction = new Action(Dict.APPLY.toString(), event -> this.apply());
        applyAction.setGraphic((Node)MaterialIcon._Navigation.CHECK.getImageView(Mapton.getIconSizeToolBarInt()));
        Action restoreDefaultsAction = new Action(Dict.RESTORE_DEFAULTS.toString(), event -> {
            DataSourceTab t = (DataSourceTab)this.mTabPane.getSelectionModel().getSelectedItem();
            t.restoreDefaults();
        });
        restoreDefaultsAction.setGraphic((Node)MaterialIcon._Action.SETTINGS_BACKUP_RESTORE.getImageView(Mapton.getIconSizeToolBarInt()));
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(applyAction, restoreDefaultsAction));
        this.mToolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.SHOW);
        this.mToolBar.setStyle("-fx-spacing: 0px;");
        this.mToolBar.setPadding(Insets.EMPTY);
        Platform.runLater(() -> FxHelper.undecorateButtons((Stream)this.mToolBar.getItems().stream()));
        this.setTop((Node)this.mToolBar);
    }
}

