/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.file_drop_switchboard;

import java.io.File;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.mapton.core.ui.file_drop_switchboard.FileDropSwitchboardView;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import se.trixon.almond.nbp.fx.FxDialogPanel;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.SwingHelper;

public class FileDropSwitchboard {
    private final JButton mDefaultButton = new JButton(Dict.OPEN.toString());
    private final List<File> mFiles;

    public FileDropSwitchboard(List<File> files) {
        this.mFiles = files;
        this.displayDialog();
    }

    private void displayDialog() {
        Object[] buttons = new JButton[]{new JButton(Dict.CANCEL.toString()), this.mDefaultButton};
        SwitchboardDialogPanel dialogPanel = new SwitchboardDialogPanel(this.mFiles);
        dialogPanel.initFx(() -> {});
        dialogPanel.setPreferredSize(SwingHelper.getUIScaledDim((int)640, (int)480));
        NotifyDescriptor d = new NotifyDescriptor((Object)dialogPanel, Dict.FILE_OPENER.toString(), 2, -1, buttons, (Object)this.mDefaultButton);
        if (this.mDefaultButton == DialogDisplayer.getDefault().notify(d)) {
            dialogPanel.openFiles();
        }
    }

    public class SwitchboardDialogPanel
    extends FxDialogPanel {
        private FileDropSwitchboardView mFileDropSwitchboardView;
        private final List<File> mFiles;
        private BorderPane mRoot;

        public SwitchboardDialogPanel(List<File> files) {
            this.mFiles = files;
        }

        @Override
        protected void fxConstructor() {
            this.setScene(this.createScene());
            this.mFileDropSwitchboardView = new FileDropSwitchboardView(this.mFiles);
            this.mRoot.setCenter((Node)this.mFileDropSwitchboardView);
            SwingUtilities.invokeLater(() -> FileDropSwitchboard.this.mDefaultButton.setEnabled(this.mFileDropSwitchboardView.hasFiles()));
        }

        void openFiles() {
            this.mFileDropSwitchboardView.openFiles();
        }

        private Scene createScene() {
            this.mRoot = new BorderPane();
            return new Scene((Parent)this.mRoot);
        }
    }
}

