/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.grid;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javafx.scene.Node;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.controlsfx.control.action.Action;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MNotificationIcons;
import org.mapton.api.Mapton;
import org.mapton.core.ui.grid.FileAction;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxActionSwing;
import se.trixon.almond.util.icons.material.MaterialIcon;
import se.trixon.almond.util.swing.FileHelper;

public class FileImportAction
extends FileAction {
    @Override
    public Action getAction(Node owner) {
        FxActionSwing action = new FxActionSwing(Dict.IMPORT.toString(), () -> {
            String dialogTitle = "%s %s".formatted(Dict.IMPORT.toString(), this.mTitle.toLowerCase());
            HashMap extensionFilters = FileChooserHelper.getExtensionFilters();
            JFileChooser fileChooser = new FileChooserBuilder(FileImportAction.class).addFileFilter((FileFilter)extensionFilters.get("grid")).setDefaultWorkingDirectory(FileHelper.getDefaultDirectory()).setFileFilter((FileFilter)extensionFilters.get("grid")).setFilesOnly(true).setTitle(dialogTitle).setSelectionApprover(FileChooserHelper.getFileExistOpenSelectionApprover((Component)Almond.getFrame())).createFileChooser();
            if (fileChooser.showOpenDialog(Almond.getFrame()) == 0) {
                new Thread(() -> {
                    File file = fileChooser.getSelectedFile();
                    try {
                        this.mManager.gridImport(file);
                        NotificationDisplayer.getDefault().notify(Dict.OPERATION_COMPLETED.toString(), (Icon)MNotificationIcons.getInformationIcon(), dialogTitle, null, NotificationDisplayer.Priority.LOW);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }, this.getClass().getCanonicalName()).start();
            }
        });
        action.setGraphic((Node)MaterialIcon._File.FOLDER_OPEN.getImageView(Mapton.getIconSizeToolBarInt()));
        return action;
    }
}

