/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.grid;

import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import org.mapton.api.MOptions;
import org.mapton.core.ui.grid.GridView;
import org.openide.util.NbBundle;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class GlobalGridView
extends VBox {
    private CheckBox mClampToGroundCheckBox;
    private CheckBox mEquatorCheckBox;
    private CheckBox mLatitudesCheckBox;
    private CheckBox mLongitudesCheckBox;
    private final MOptions mOptions = MOptions.getInstance();
    private CheckBox mPlotCheckBox;
    private CheckBox mPolarAntarticCheckBox;
    private CheckBox mPolarArticCheckBox;
    private CheckBox mTropicCancerCheckBox;
    private CheckBox mTropicCapricornCheckBox;

    public GlobalGridView() {
        this.createUI();
        this.initStates();
        this.initListeners();
    }

    private void createUI() {
        ResourceBundle bundle = NbBundle.getBundle(GridView.class);
        this.mPlotCheckBox = new CheckBox(Dict.GLOBAL.toString());
        this.mPlotCheckBox.setStyle("-fx-font-weight: bold; -fx-font-size: 1.3em");
        this.mClampToGroundCheckBox = new CheckBox("CLAMP TO GROUND");
        this.mLongitudesCheckBox = new CheckBox(bundle.getString("longitudes"));
        this.mLatitudesCheckBox = new CheckBox(bundle.getString("latitudes"));
        this.mPolarArticCheckBox = new CheckBox(bundle.getString("arctic_circle"));
        this.mTropicCancerCheckBox = new CheckBox(bundle.getString("tropic_cancer"));
        this.mEquatorCheckBox = new CheckBox(bundle.getString("equator"));
        this.mTropicCapricornCheckBox = new CheckBox(bundle.getString("tropic_capricorn"));
        this.mPolarAntarticCheckBox = new CheckBox(bundle.getString("antarctic_circle"));
        Label presentationLabel = new Label(bundle.getString("major_latitudes"));
        presentationLabel.setFont(new Font(FxHelper.getScaledFontSize() * 1.2));
        VBox vbox = new VBox(8.0, new Node[]{this.mLongitudesCheckBox, this.mLatitudesCheckBox, presentationLabel, this.mPolarArticCheckBox, this.mTropicCancerCheckBox, this.mEquatorCheckBox, this.mTropicCapricornCheckBox, this.mPolarAntarticCheckBox});
        vbox.disableProperty().bind((ObservableValue)this.mPlotCheckBox.selectedProperty().not());
        this.setSpacing(8.0);
        this.getChildren().addAll((Object[])new Node[]{this.mPlotCheckBox, vbox});
        vbox.setPadding(new Insets(4.0, 0.0, 0.0, 16.0));
    }

    private void initListeners() {
        this.mPlotCheckBox.setOnAction(event -> this.mOptions.put("grid.global.plot", this.mPlotCheckBox.isSelected()));
        this.mClampToGroundCheckBox.setOnAction(event -> this.mOptions.put("global_clamp_to_ground", this.mClampToGroundCheckBox.isSelected()));
        this.mLongitudesCheckBox.setOnAction(event -> this.mOptions.put("grid.global.longitudes", this.mLongitudesCheckBox.isSelected()));
        this.mLatitudesCheckBox.setOnAction(event -> this.mOptions.put("grid.global.latitudes", this.mLatitudesCheckBox.isSelected()));
        this.mPolarArticCheckBox.setOnAction(event -> this.mOptions.put("grid.global.polar_arctic", this.mPolarArticCheckBox.isSelected()));
        this.mTropicCancerCheckBox.setOnAction(event -> this.mOptions.put("grid.global.tropic_cancer", this.mTropicCancerCheckBox.isSelected()));
        this.mEquatorCheckBox.setOnAction(event -> this.mOptions.put("grid.global.equator", this.mEquatorCheckBox.isSelected()));
        this.mTropicCapricornCheckBox.setOnAction(event -> this.mOptions.put("grid.global.tropic_capricorn", this.mTropicCapricornCheckBox.isSelected()));
        this.mPolarAntarticCheckBox.setOnAction(event -> this.mOptions.put("grid.global.polar_antarctic", this.mPolarAntarticCheckBox.isSelected()));
    }

    private void initStates() {
        this.mPlotCheckBox.setSelected(this.mOptions.is("grid.global.plot", new boolean[0]));
        this.mClampToGroundCheckBox.setSelected(this.mOptions.is("global_clamp_to_ground", new boolean[0]));
        this.mLongitudesCheckBox.setSelected(this.mOptions.is("grid.global.longitudes", new boolean[0]));
        this.mLatitudesCheckBox.setSelected(this.mOptions.is("grid.global.latitudes", new boolean[0]));
        this.mPolarArticCheckBox.setSelected(this.mOptions.is("grid.global.polar_arctic", new boolean[0]));
        this.mTropicCancerCheckBox.setSelected(this.mOptions.is("grid.global.tropic_cancer", new boolean[0]));
        this.mEquatorCheckBox.setSelected(this.mOptions.is("grid.global.equator", new boolean[0]));
        this.mTropicCapricornCheckBox.setSelected(this.mOptions.is("grid.global.tropic_capricorn", new boolean[0]));
        this.mPolarAntarticCheckBox.setSelected(this.mOptions.is("grid.global.polar_antarctic", new boolean[0]));
    }
}

