/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.grid;

import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.SwingUtilities;
import org.mapton.api.MDict;
import org.mapton.api.MLocalGrid;
import org.mapton.api.MLocalGridManager;
import org.mapton.core.ui.grid.LocalGridPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.SwingHelper;

public class LocalGridEditor {
    private final MLocalGridManager mManager = MLocalGridManager.getInstance();

    public void edit(MLocalGrid aLocalGrid) {
        SwingUtilities.invokeLater(() -> {
            boolean add;
            MLocalGrid newLocalGrid = aLocalGrid;
            boolean bl = add = aLocalGrid == null;
            if (add) {
                newLocalGrid = new MLocalGrid();
            }
            MLocalGrid localGrid = newLocalGrid;
            LocalGridPanel localGridPanel = new LocalGridPanel();
            DialogDescriptor d = new DialogDescriptor((Object)localGridPanel, MDict.GRID.toString());
            localGridPanel.setNotifyDescriptor((NotifyDescriptor)d);
            localGridPanel.initFx(() -> localGridPanel.load(localGrid));
            localGridPanel.setPreferredSize(SwingHelper.getUIScaledDim((int)600, (int)380));
            if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)d)) {
                Platform.runLater(() -> {
                    localGridPanel.save(localGrid);
                    if (add) {
                        this.mManager.getItems().add((Object)localGrid);
                    }
                    FXCollections.sort((ObservableList)this.mManager.getItems(), (o1, o2) -> o1.getName().compareTo(o2.getName()));
                });
            }
        });
    }

    public void remove(MLocalGrid localGrid) {
        SwingUtilities.invokeLater(() -> {
            Object[] buttons = new String[]{Dict.CANCEL.toString(), Dict.REMOVE.toString()};
            NotifyDescriptor d = new NotifyDescriptor((Object)Dict.Dialog.MESSAGE_PROFILE_REMOVE.toString().formatted(localGrid.getName()), Dict.Dialog.TITLE_REMOVE_S.toString().formatted(MDict.GRID.toString().toLowerCase()) + "?", 2, 2, buttons, (Object)Dict.REMOVE.toString());
            if (Dict.REMOVE.toString() == DialogDisplayer.getDefault().notify(d)) {
                Platform.runLater(() -> this.mManager.removeAll(new MLocalGrid[]{localGrid}));
            }
        });
    }
}

