/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.grid;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.util.StringConverter;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.mapton.api.MCooTrans;
import org.mapton.api.MCrsManager;
import org.mapton.api.MDict;
import org.mapton.api.MLocalGrid;
import org.openide.util.NbBundle;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class LocalGridView
extends GridPane {
    private final ResourceBundle mBundle = NbBundle.getBundle(LocalGridView.class);
    private ColorPicker mColorPicker;
    private final ComboBox<MCooTrans> mCooTransComboBox = new ComboBox();
    private Spinner<Integer> mLatCountSpinner;
    private Spinner<Double> mLatStartSpinner;
    private Spinner<Double> mLatStepSpinner;
    private Spinner<Double> mLineWidthSpinner;
    private Spinner<Integer> mLonCountSpinner;
    private Spinner<Double> mLonStartSpinner;
    private Spinner<Double> mLonStepSpinner;
    private TextField mNameTextField;

    public LocalGridView() {
        this.createUI();
    }

    public void load(MLocalGrid grid) {
        this.mNameTextField.setText(grid.getName());
        this.mColorPicker.setValue((Object)FxHelper.colorFromHexRGBA((String)grid.getColor()));
        this.mLatStartSpinner.getValueFactory().setValue((Object)grid.getLatStart());
        this.mLatStepSpinner.getValueFactory().setValue((Object)grid.getLatStep());
        this.mLatCountSpinner.getValueFactory().setValue((Object)grid.getLatCount());
        this.mLonStartSpinner.getValueFactory().setValue((Object)grid.getLonStart());
        this.mLonStepSpinner.getValueFactory().setValue((Object)grid.getLonStep());
        this.mLonCountSpinner.getValueFactory().setValue((Object)grid.getLonCount());
        this.mLineWidthSpinner.getValueFactory().setValue((Object)grid.getLineWidth());
        if (!this.mCooTransComboBox.getItems().isEmpty()) {
            MCooTrans cooTrans = MCooTrans.getCooTrans((String)grid.getCooTrans());
            if (cooTrans == null) {
                cooTrans = (MCooTrans)this.mCooTransComboBox.getItems().get(0);
            }
            this.mCooTransComboBox.getSelectionModel().select((Object)cooTrans);
        }
    }

    public void save(MLocalGrid grid) {
        grid.setName(this.mNameTextField.getText());
        grid.setCooTrans(((MCooTrans)this.mCooTransComboBox.getSelectionModel().getSelectedItem()).getName());
        grid.setColor(FxHelper.colorToHexRGB((Color)((Color)this.mColorPicker.getValue())));
        grid.setLineWidth(((Double)this.mLineWidthSpinner.getValue()).doubleValue());
        grid.setLatStart(((Double)this.mLatStartSpinner.getValue()).doubleValue());
        grid.setLatStep(((Double)this.mLatStepSpinner.getValue()).doubleValue());
        grid.setLatCount(((Integer)this.mLatCountSpinner.getValue()).intValue());
        grid.setLonStart(((Double)this.mLonStartSpinner.getValue()).doubleValue());
        grid.setLonStep(((Double)this.mLonStepSpinner.getValue()).doubleValue());
        grid.setLonCount(((Integer)this.mLonCountSpinner.getValue()).intValue());
    }

    private void autoSizeColumn(GridPane gridPane, int columnCount) {
        gridPane.getColumnConstraints().clear();
        for (int i = 0; i < columnCount; ++i) {
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setPercentWidth(100.0 / (double)columnCount);
            gridPane.getColumnConstraints().add((Object)columnConstraints);
        }
    }

    private void autoSizeRegion(Region ... regions) {
        for (Region region : regions) {
            GridPane.setHgrow((Node)region, (Priority)Priority.ALWAYS);
            GridPane.setFillWidth((Node)region, (Boolean)true);
            region.setMaxWidth(Double.MAX_VALUE);
        }
    }

    private void createUI() {
        this.mNameTextField = new TextField();
        this.mColorPicker = new ColorPicker();
        this.mLatStartSpinner = new Spinner(-2.147483648E9, Double.MAX_VALUE, 0.0, 1.0);
        this.mLatStepSpinner = new Spinner(1.0, Double.MAX_VALUE, 1.0);
        this.mLatCountSpinner = new Spinner(1, Integer.MAX_VALUE, 1);
        this.mLonStartSpinner = new Spinner(-2.147483648E9, Double.MAX_VALUE, 0.0, 1.0);
        this.mLonStepSpinner = new Spinner(1.0, Double.MAX_VALUE, 1.0);
        this.mLonCountSpinner = new Spinner(1, Integer.MAX_VALUE, 1);
        this.mLineWidthSpinner = new Spinner(0.1, 20.0, 0.1);
        StringConverter<Double> converter = new StringConverter<Double>(){
            private final DecimalFormat mDecimalFormat = new DecimalFormat("#.######");

            public Double fromString(String value) {
                try {
                    if (value == null) {
                        return null;
                    }
                    if ((value = value.trim()).length() < 1) {
                        return null;
                    }
                    return this.mDecimalFormat.parse(value).doubleValue();
                }
                catch (ParseException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public String toString(Double value) {
                if (value == null) {
                    return "";
                }
                return this.mDecimalFormat.format(value);
            }
        };
        this.mLatStartSpinner.getValueFactory().setConverter((StringConverter)converter);
        this.mLonStartSpinner.getValueFactory().setConverter((StringConverter)converter);
        FxHelper.setEditable((boolean)true, (Spinner[])new Spinner[]{this.mLatCountSpinner, this.mLatStartSpinner, this.mLatStepSpinner, this.mLonCountSpinner, this.mLonStartSpinner, this.mLonStepSpinner, this.mLineWidthSpinner});
        FxHelper.autoCommitSpinners((Spinner[])new Spinner[]{this.mLatCountSpinner, this.mLatStartSpinner, this.mLatStepSpinner, this.mLonCountSpinner, this.mLonStartSpinner, this.mLonStepSpinner, this.mLineWidthSpinner});
        Label nameLabel = new Label(Dict.NAME.toString());
        Label latStartLabel = new Label(MDict.ORIGIN.toString());
        Label latStepLabel = new Label(this.mBundle.getString("step"));
        Label latCountLabel = new Label(this.mBundle.getString("count"));
        Label lonStartLabel = new Label(MDict.ORIGIN.toString());
        Label lonStepLabel = new Label(this.mBundle.getString("step"));
        Label lonCountLabel = new Label(this.mBundle.getString("count"));
        Label latLabel = new Label(this.mBundle.getString("lat"));
        Label lonLabel = new Label(this.mBundle.getString("lon"));
        Font font = new Font(FxHelper.getScaledFontSize() * 1.4);
        latLabel.setFont(font);
        lonLabel.setFont(font);
        Label lineWidthLabel = new Label(MDict.LINE_WIDTH.toString());
        Label cooTransLabel = new Label(MDict.COORDINATE_SYSTEM.toString());
        Label colorLabel = new Label(Dict.COLOR.toString());
        boolean col = false;
        int row = 0;
        GridPane headerPane = new GridPane();
        headerPane.addRow(0, new Node[]{nameLabel, cooTransLabel});
        headerPane.addRow(1, new Node[]{this.mNameTextField, this.mCooTransComboBox});
        headerPane.addRow(2, new Node[]{lineWidthLabel, colorLabel});
        headerPane.addRow(3, new Node[]{this.mLineWidthSpinner, this.mColorPicker});
        headerPane.setHgap(8.0);
        this.autoSizeRegion(new Region[]{this.mNameTextField, this.mCooTransComboBox, this.mColorPicker, this.mLineWidthSpinner});
        this.autoSizeColumn(headerPane, 2);
        this.addRow(row, new Node[]{headerPane});
        GridPane latPane = new GridPane();
        latPane.add((Node)latLabel, 0, 0);
        latPane.addRow(1, new Node[]{latStartLabel, latStepLabel, latCountLabel});
        latPane.addRow(2, new Node[]{this.mLatStartSpinner, this.mLatStepSpinner, this.mLatCountSpinner});
        latPane.setHgap(8.0);
        this.autoSizeRegion(new Region[]{this.mLatStartSpinner, this.mLatStepSpinner, this.mLatCountSpinner});
        this.autoSizeColumn(latPane, 3);
        this.addRow(++row, new Node[]{latPane});
        GridPane lonPane = new GridPane();
        lonPane.add((Node)lonLabel, 0, 0);
        lonPane.addRow(1, new Node[]{lonStartLabel, lonStepLabel, lonCountLabel});
        lonPane.addRow(2, new Node[]{this.mLonStartSpinner, this.mLonStepSpinner, this.mLonCountSpinner});
        lonPane.setHgap(8.0);
        this.autoSizeRegion(new Region[]{this.mLonStartSpinner, this.mLonStepSpinner, this.mLonCountSpinner});
        this.autoSizeColumn(lonPane, 3);
        this.addRow(++row, new Node[]{lonPane});
        this.autoSizeRegion(new Region[]{headerPane, latPane, lonPane});
        Insets rowInsets = new Insets(0.0, 0.0, 8.0, 0.0);
        GridPane.setMargin((Node)headerPane, (Insets)rowInsets);
        GridPane.setMargin((Node)latPane, (Insets)rowInsets);
        GridPane.setMargin((Node)lonPane, (Insets)rowInsets);
        GridPane.setMargin((Node)this.mNameTextField, (Insets)rowInsets);
        GridPane.setMargin(this.mCooTransComboBox, (Insets)rowInsets);
        this.initValidation();
        this.setPadding(new Insets(8.0, 16.0, 0.0, 16.0));
        Insets topInsets = new Insets(8.0, 0.0, 8.0, 0.0);
        VBox.setMargin((Node)latStartLabel, (Insets)topInsets);
        VBox.setMargin((Node)lonStartLabel, (Insets)topInsets);
        this.mCooTransComboBox.getItems().setAll((Collection)MCrsManager.getInstance().getItems());
        this.mCooTransComboBox.setItems((ObservableList)this.mCooTransComboBox.getItems().sorted());
    }

    private void initValidation() {
        String text_is_required = "Text is required";
        boolean indicateRequired = false;
        ValidationSupport validationSupport = new ValidationSupport();
        Validator emptyValidator = Validator.createEmptyValidator((String)"Text is required");
        validationSupport.registerValidator((Control)this.mNameTextField, indicateRequired, emptyValidator);
        validationSupport.validationResultProperty().addListener((observable, oldValue, newValue) -> {});
        validationSupport.initInitialDecoration();
    }
}

