/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.mapton.core.ui.options.BasicPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class BasicOptionsPanelController
extends OptionsPanelController {
    private boolean mChanged;
    private BasicPanel mPanel;
    private final PropertyChangeSupport mPropertyChangeSupport = new PropertyChangeSupport((Object)this);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.mPropertyChangeSupport.addPropertyChangeListener(l);
    }

    public void applyChanges() {
        SwingUtilities.invokeLater(() -> {
            this.getPanel().store();
            this.mChanged = false;
        });
    }

    public void cancel() {
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public boolean isChanged() {
        return this.mChanged;
    }

    public boolean isValid() {
        return this.getPanel().valid();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.mPropertyChangeSupport.removePropertyChangeListener(l);
    }

    public void update() {
        this.getPanel().load();
        this.mChanged = false;
    }

    void changed() {
        if (!this.mChanged) {
            this.mChanged = true;
            this.mPropertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.mPropertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private BasicPanel getPanel() {
        if (this.mPanel == null) {
            this.mPanel = new BasicPanel(this);
        }
        return this.mPanel;
    }
}

