/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javax.swing.JPanel;
import org.mapton.api.MOptions;
import org.mapton.core.ui.options.BasicOptionsPanelController;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.fx.FxPanel;
import se.trixon.almond.util.fx.FxHelper;

final class BasicPanel
extends JPanel {
    private final ResourceBundle mBundle;
    private final BasicOptionsPanelController mController;
    private final FxPanel mFxPanel;
    private ComboBox<String> mDecimalSymbolComboBox;
    private ComboBox<String> mCoordinateSeparatorComboBox;
    private final MOptions mOptions = MOptions.getInstance();

    BasicPanel(BasicOptionsPanelController controller) {
        this.mBundle = NbBundle.getBundle(MOptions.class);
        this.mController = controller;
        this.mFxPanel = new FxPanel(){

            @Override
            protected void fxConstructor() {
                this.setScene(this.createScene());
                this.initListeners();
            }

            private Scene createScene() {
                Label extrasSectionLabel = new Label(BasicPanel.this.mBundle.getString("extras_copy_location"));
                extrasSectionLabel.setPadding(FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)6.0, (double)0.0));
                Font sectionFont = Font.font((double)(Font.getDefault().getSize() * 1.5));
                extrasSectionLabel.setFont(sectionFont);
                int row = 0;
                GridPane gp = new GridPane();
                gp.addRow(row++, new Node[]{extrasSectionLabel});
                Label decimalSymbolLabel = new Label(BasicPanel.this.mBundle.getString("decimal_symbol"));
                Label coordinateSeparatorLabel = new Label(BasicPanel.this.mBundle.getString("coordinate_separator"));
                int n = row++;
                Node[] nodeArray = new Node[2];
                nodeArray[0] = decimalSymbolLabel;
                BasicPanel.this.mDecimalSymbolComboBox = new ComboBox();
                nodeArray[1] = BasicPanel.this.mDecimalSymbolComboBox;
                gp.addRow(n, nodeArray);
                int n2 = row++;
                Node[] nodeArray2 = new Node[2];
                nodeArray2[0] = coordinateSeparatorLabel;
                BasicPanel.this.mCoordinateSeparatorComboBox = new ComboBox();
                nodeArray2[1] = BasicPanel.this.mCoordinateSeparatorComboBox;
                gp.addRow(n2, nodeArray2);
                GridPane.setColumnSpan((Node)extrasSectionLabel, (Integer)Integer.MAX_VALUE);
                gp.setPadding(FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)0.0, (double)16.0));
                FxHelper.setPadding((Insets)FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)0.0, (double)20.0), (Region[])new Region[]{decimalSymbolLabel, coordinateSeparatorLabel});
                FxHelper.setMargin((Insets)FxHelper.getUIScaledInsets((double)4.0, (double)0.0, (double)4.0, (double)16.0), (Region[])new Region[]{BasicPanel.this.mCoordinateSeparatorComboBox, BasicPanel.this.mDecimalSymbolComboBox});
                BasicPanel.this.mDecimalSymbolComboBox.getItems().addAll((Object[])new String[]{".", ","});
                BasicPanel.this.mCoordinateSeparatorComboBox.getItems().addAll((Object[])new String[]{".", ",", ";", "SPACE", "TAB"});
                BasicPanel.this.mDecimalSymbolComboBox.valueProperty().bindBidirectional((Property)BasicPanel.this.mOptions.decimalSymbolProperty());
                BasicPanel.this.mCoordinateSeparatorComboBox.valueProperty().bindBidirectional((Property)BasicPanel.this.mOptions.coordinateSeparatorProperty());
                ScrollPane scrollPane = new ScrollPane((Node)gp);
                return new Scene((Parent)gp);
            }

            private void initListeners() {
                ChangeListener changeListener = (observable, oldValue, newValue) -> BasicPanel.this.mController.changed();
                BasicPanel.this.mDecimalSymbolComboBox.valueProperty().addListener(changeListener);
                BasicPanel.this.mCoordinateSeparatorComboBox.valueProperty().addListener(changeListener);
            }
        };
        this.mFxPanel.initFx(null);
        this.mFxPanel.setPreferredSize(null);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.mFxPanel), "Center");
    }

    void load() {
        Platform.runLater(() -> this.loadFX());
    }

    void store() {
        Platform.runLater(() -> this.storeFX());
    }

    boolean valid() {
        return true;
    }

    private void loadFX() {
    }

    private void storeFX() {
    }
}

