/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.options;

import impl.org.controlsfx.skin.ListSelectionViewSkin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.ListSelectionView;
import org.controlsfx.control.textfield.TextFields;
import org.geotools.referencing.CRS;
import org.mapton.api.MCrsManager;
import org.mapton.api.MOptions;
import org.mapton.core.ui.options.CrsOptionsPanelController;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.fx.FxPanel;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.DelayedResetRunner;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.control.LogPanel;

final class CrsPanel
extends JPanel {
    private final ResourceBundle mBundle;
    private final CrsOptionsPanelController mController;
    private final Form mForm;
    private final MCrsManager mManager = MCrsManager.getInstance();

    CrsPanel(CrsOptionsPanelController controller) {
        this.mBundle = NbBundle.getBundle(MOptions.class);
        this.mController = controller;
        this.mForm = new Form();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.mForm), "Center");
    }

    void load() {
        Platform.runLater(() -> this.mForm.load());
    }

    void store() {
        Platform.runLater(() -> this.mForm.store());
    }

    boolean valid() {
        return true;
    }

    class Form
    extends FxPanel {
        private final DelayedResetRunner mDelayedResetRunner;
        private TextField mFilterTextField;
        private final ObjectProperty<ObservableList<CoordinateReferenceSystem>> mFilteredSystems = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        private ListSelectionView<CoordinateReferenceSystem> mListSelectionView;
        private final LogPanel mLogPanel = new LogPanel();
        private final Label mSourceCountLabel = new Label();
        private ListView mSourceListView;
        private final Label mTargetCountLabel = new Label();
        private ListView mTargetListView;

        public Form() {
            this.mDelayedResetRunner = new DelayedResetRunner(300, () -> this.filter(this.mFilterTextField.getText()));
            this.initFx(null);
            this.setPreferredSize(null);
        }

        @Override
        protected void fxConstructor() {
            this.setScene(new Scene(this.createUI()));
            this.initListeners();
            this.filter(null);
        }

        private Parent createUI() {
            GridPane root = new GridPane();
            this.mFilterTextField = TextFields.createClearableTextField();
            this.mFilterTextField.setPromptText(Dict.FILTER.toString());
            this.mListSelectionView = new ListSelectionView();
            this.mListSelectionView.setSourceHeader((Node)new Label(Dict.AVAILABLE.toString()));
            this.mListSelectionView.setSourceFooter((Node)this.mSourceCountLabel);
            this.mListSelectionView.setTargetHeader((Node)new Label(Dict.ACTIVE_ALT.toString()));
            this.mListSelectionView.setTargetFooter((Node)this.mTargetCountLabel);
            this.mSourceCountLabel.setAlignment(Pos.BASELINE_RIGHT);
            this.mTargetCountLabel.setAlignment(Pos.BASELINE_RIGHT);
            root.addRow(0, new Node[]{this.mFilterTextField});
            root.addRow(1, new Node[]{this.mListSelectionView});
            root.addRow(2, new Node[]{this.mLogPanel});
            this.mListSelectionView.sourceItemsProperty().bind(this.mFilteredSystems);
            this.mListSelectionView.setCellFactory(list -> new CrsListCell());
            FxHelper.autoSizeRegionHorizontal((Region[])new Region[]{this.mFilterTextField, this.mListSelectionView, this.mLogPanel});
            FxHelper.autoSizeRegionVertical((Region[])new Region[]{this.mListSelectionView});
            this.mLogPanel.setPrefHeight((double)FxHelper.getUIScaled((int)140));
            return root;
        }

        private void filter(String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                ((ObservableList)this.mFilteredSystems.get()).setAll((Collection)CrsPanel.this.mManager.getAllSystems());
            } else {
                ((ObservableList)this.mFilteredSystems.get()).clear();
                for (CoordinateReferenceSystem crs : CrsPanel.this.mManager.getAllSystems()) {
                    String dov = "";
                    if (crs.getDomainOfValidity() != null) {
                        dov = crs.getDomainOfValidity().getDescription().toString(Locale.getDefault());
                    }
                    if (!StringUtils.containsIgnoreCase((CharSequence)crs.toWKT(), (CharSequence)s) && !StringUtils.containsIgnoreCase((CharSequence)crs.getName().toString(), (CharSequence)s) && !StringUtils.containsIgnoreCase((CharSequence)dov, (CharSequence)s)) continue;
                    ((ObservableList)this.mFilteredSystems.get()).add((Object)crs);
                }
            }
            ((ObservableList)this.mFilteredSystems.get()).removeAll((Collection)this.mListSelectionView.getTargetItems());
            this.updateCounters();
        }

        private void initListeners() {
            this.mFilterTextField.textProperty().addListener((observable, oldValue, newValue) -> this.mDelayedResetRunner.reset());
            ListSelectionViewSkin skin = (ListSelectionViewSkin)this.mListSelectionView.getSkin();
            this.mSourceListView = skin.getSourceListView();
            this.mTargetListView = skin.getTargetListView();
            this.mSourceCountLabel.prefWidthProperty().bind((ObservableValue)this.mSourceListView.widthProperty());
            this.mTargetCountLabel.prefWidthProperty().bind((ObservableValue)this.mTargetListView.widthProperty());
            this.mSourceListView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.preview((CoordinateReferenceSystem)newValue));
            this.mTargetListView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.preview((CoordinateReferenceSystem)newValue));
            this.mListSelectionView.getSourceItems().addListener(c -> this.updateCounters());
            this.mListSelectionView.getTargetItems().addListener(c -> this.updateCounters());
        }

        private void load() {
            this.mListSelectionView.getTargetItems().setAll((Collection)CrsPanel.this.mManager.getSelectedSystems());
        }

        private void preview(CoordinateReferenceSystem crs) {
            try {
                StringBuilder sb = new StringBuilder(CRS.toSRS((CoordinateReferenceSystem)crs)).append("\n\n");
                sb.append(crs.toWKT()).append("\n\n");
                sb.append(crs.getDomainOfValidity());
                this.mLogPanel.setText(sb.toString());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        private void store() {
            CrsPanel.this.mManager.save(this.mListSelectionView.getTargetItems());
        }

        private void updateCounters() {
            this.mSourceCountLabel.setText("%d/%d".formatted(this.mListSelectionView.getSourceItems().size(), CrsPanel.this.mManager.getAllSystems().size()));
            this.mTargetCountLabel.setText("%d/%d".formatted(this.mListSelectionView.getTargetItems().size(), CrsPanel.this.mManager.getAllSystems().size()));
        }
    }

    class CrsListCell
    extends ListCell<CoordinateReferenceSystem> {
        private final VBox mBox = new VBox();
        private final Label mDescLabel = new Label();
        private final Label mNameLabel = new Label();

        public CrsListCell() {
            this.createUI();
        }

        protected void updateItem(CoordinateReferenceSystem crs, boolean empty) {
            super.updateItem((Object)crs, empty);
            if (crs == null || empty) {
                this.clearContent();
            } else {
                this.addContent(crs);
            }
        }

        private void addContent(CoordinateReferenceSystem crs) {
            this.setText(null);
            this.mNameLabel.setText(crs.getName().toString());
            try {
                this.mDescLabel.setText(crs.getDomainOfValidity().getDescription().toString(Locale.getDefault()));
            }
            catch (NullPointerException e) {
                this.mDescLabel.setText("");
            }
            this.setGraphic((Node)this.mBox);
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
        }

        private void createUI() {
            String fontFamily = Font.getDefault().getFamily();
            double fontSize = FxHelper.getScaledFontSize();
            this.mNameLabel.setFont(Font.font((String)fontFamily, (FontWeight)FontWeight.BOLD, (double)fontSize));
            this.mDescLabel.setFont(Font.font((String)fontFamily, (FontPosture)FontPosture.ITALIC, (double)fontSize));
            this.mBox.setSpacing((double)FxHelper.getUIScaled((int)4));
            this.mBox.getChildren().setAll((Object[])new Node[]{this.mNameLabel, this.mDescLabel});
        }
    }
}

