/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javax.swing.JPanel;
import org.mapton.api.MGenericLoader;
import org.mapton.api.MGenericSaver;
import org.mapton.core.ui.options.SimpleObjectStorageOptionsPanelController;
import org.mapton.core.ui.simple_object_storage.BooleanStorageTabPane;
import org.mapton.core.ui.simple_object_storage.StringStorageTabPane;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.fx.FxPanel;

final class SimpleObjectStoragePanel
extends JPanel {
    private final SimpleObjectStorageOptionsPanelController mController;
    private final FxPanel mFxPanel;
    private TabPane mTabPane;
    private final ResourceBundle mBundle = NbBundle.getBundle(SimpleObjectStoragePanel.class);

    SimpleObjectStoragePanel(SimpleObjectStorageOptionsPanelController controller) {
        this.mController = controller;
        this.mFxPanel = new FxPanel(){

            @Override
            protected void fxConstructor() {
                this.setScene(this.createScene());
                this.initListeners();
            }

            private Scene createScene() {
                SimpleObjectStoragePanel.this.mTabPane = new TabPane();
                SimpleObjectStoragePanel.this.mTabPane.setSide(Side.TOP);
                SimpleObjectStoragePanel.this.mTabPane.getTabs().setAll((Object[])new Tab[]{new Tab(SimpleObjectStoragePanel.this.mBundle.getString("string"), (Node)new StringStorageTabPane()), new Tab(SimpleObjectStoragePanel.this.mBundle.getString("boolean"), (Node)new BooleanStorageTabPane())});
                SimpleObjectStoragePanel.this.mTabPane.getTabs().forEach(tab -> tab.setClosable(false));
                return new Scene((Parent)SimpleObjectStoragePanel.this.mTabPane);
            }

            private void initListeners() {
            }
        };
        this.mFxPanel.initFx(null);
        this.mFxPanel.setPreferredSize(null);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.mFxPanel), "Center");
    }

    void load() {
        Platform.runLater(() -> this.mTabPane.getTabs().stream().map(tab -> tab.getContent()).filter(content -> content instanceof MGenericLoader).forEachOrdered(content -> ((MGenericLoader)content).load(null)));
    }

    void store() {
        Platform.runLater(() -> this.mTabPane.getTabs().stream().map(tab -> tab.getContent()).filter(content -> content instanceof MGenericSaver).forEachOrdered(content -> ((MGenericSaver)content).save(null)));
    }

    boolean valid() {
        return true;
    }
}

