/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.simple_object_storage;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MSimpleObjectStorageString;
import org.mapton.core.ui.simple_object_storage.BaseTab;
import org.openide.util.Lookup;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.control.FileChooserPane;

public class StringStorageTab<T extends MSimpleObjectStorageString>
extends BaseTab {
    private final Class<T> mClass;
    private final HashMap<Class, TextField> mClassToTextField = new HashMap();
    private final VBox mItemBox = new VBox((double)FxHelper.getUIScaled((int)8));
    private final ScrollPane mScrollPane;

    public StringStorageTab(Class<T> c, String title) {
        super(title);
        this.mClass = c;
        this.mScrollPane = new ScrollPane((Node)this.mItemBox);
        this.setContent((Node)this.mScrollPane);
        this.mScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.mScrollPane.setFitToWidth(true);
        this.mItemBox.setPadding(FxHelper.getUIScaledInsets((double)8.0));
        Lookup.getDefault().lookupResult(c).addLookupListener(ev -> this.populateItems());
        this.populateItems();
    }

    public void load(Object object) {
        Lookup.getDefault().lookupAll(this.mClass).forEach(simpleStorage -> this.mClassToTextField.get(simpleStorage.getClass()).setText(this.mManager.getString(simpleStorage.getClass(), (String)simpleStorage.getDefaultValue())));
    }

    public void save(Object object) {
        Lookup.getDefault().lookupAll(this.mClass).forEach(simpleStorage -> this.mManager.putString(simpleStorage.getClass(), this.mClassToTextField.get(simpleStorage.getClass()).getText()));
    }

    private void populateItems() {
        FxHelper.runLater(() -> {
            ArrayList simpleStorages = new ArrayList(Lookup.getDefault().lookupAll(this.mClass));
            Comparator c1 = (o1, o2) -> StringUtils.defaultString((String)o1.getGroup()).compareToIgnoreCase(StringUtils.defaultString((String)o2.getGroup()));
            Comparator c2 = (o1, o2) -> StringUtils.defaultString((String)o1.getName()).compareToIgnoreCase(StringUtils.defaultString((String)o2.getName()));
            simpleStorages.sort(c1.thenComparing(c2));
            HashSet<String> groups = new HashSet<String>();
            this.mClassToTextField.clear();
            for (MSimpleObjectStorageString stringStorage : simpleStorages) {
                VBox box;
                TextField textField;
                if (stringStorage instanceof MSimpleObjectStorageString.Path) {
                    MSimpleObjectStorageString.Path sossp;
                    MSimpleObjectStorageString.Path storagePath = sossp = (MSimpleObjectStorageString.Path)stringStorage;
                    FileChooserPane fileChooserPane = new FileChooserPane("title", storagePath.getName(), storagePath.getObjectMode(), SelectionMode.SINGLE);
                    textField = fileChooserPane.getTextField();
                    box = new VBox(new Node[]{fileChooserPane});
                } else {
                    Label nameLabel = new Label(stringStorage.getName());
                    textField = new TextField();
                    textField.prefWidthProperty().bind((ObservableValue)this.mItemBox.widthProperty());
                    box = new VBox(new Node[]{nameLabel, textField});
                }
                textField.setPromptText(stringStorage.getPromptText());
                textField.setTooltip(new Tooltip(stringStorage.getTooltipText()));
                this.mClassToTextField.put(stringStorage.getClass(), textField);
                String group = stringStorage.getGroup();
                if (!groups.contains(group)) {
                    groups.add(group);
                    box.getChildren().add(0, (Object)this.getGroupLabel(group));
                }
                this.mItemBox.getChildren().add((Object)box);
            }
        });
    }
}

