/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.updater;

import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.mapton.api.MMaskerPaneBase;
import org.mapton.api.MPrint;
import org.mapton.api.MUpdater;
import se.trixon.almond.util.Dict;

public class UpdaterMaskerPane
extends MMaskerPaneBase {
    private final MPrint mPrint = new MPrint("updater.logger");
    private final BooleanProperty mRunningProperty = new SimpleBooleanProperty(false);

    public BooleanProperty runningProperty() {
        return this.mRunningProperty;
    }

    public void update(ObservableList<MUpdater> updaters, Runnable r) {
        this.mMaskerPane.setVisible(true);
        this.mRunningProperty.set(true);
        new Thread(() -> {
            for (MUpdater updater : FXCollections.observableArrayList((Collection)updaters)) {
                if (!updater.isMarkedForUpdate()) continue;
                this.mPrint.out("%s %s/%s".formatted("Update", updater.getCategory(), updater.getName()));
                updater.run();
                this.mPrint.out("%s %s/%s, %s".formatted("Update", updater.getCategory(), updater.getName(), Dict.DONE.toString().toLowerCase()));
            }
            Platform.runLater(() -> {
                r.run();
                this.mMaskerPane.setVisible(false);
                this.notify(Dict.OPERATION_COMPLETED.toString());
                this.mRunningProperty.set(false);
            });
        }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
    }
}

