/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import javax.measure.Unit;
import org.geotools.measure.UnitFormat;
import org.geotools.util.Utilities;

public final class Measure
extends Number {
    private static final long serialVersionUID = 6917234039472328164L;
    private final double value;
    private final Unit<?> unit;

    public Measure(double value, Unit<?> unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.value);
        return (int)code ^ (int)(code >>> 32) ^ this.unit.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Measure) {
            Measure that = (Measure)object;
            return Utilities.equals(this.value, that.value) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value) + " " + UnitFormat.getInstance().format(this.unit);
    }
}

