/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.ce_chartfx.api;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.CrosshairIndicator;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import javafx.util.StringConverter;

public class ChartHelper {
    public static StringConverter<Number> createTickLabelFormatter(final int decimals) {
        return new StringConverter<Number>(){

            public Number fromString(String string) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String toString(Number t) {
                String format = "%%.%df".formatted(decimals);
                return format.formatted(t.doubleValue());
            }
        };
    }

    public static XYChart createXYChart(Axis ... axes) {
        XYChart chart = new XYChart(axes);
        chart.legendVisibleProperty().set(true);
        Zoomer zoomer = new Zoomer();
        DataPointTooltip dataPointTooltip = new DataPointTooltip();
        TableViewer tableViewer = new TableViewer();
        Panner panner = new Panner();
        CrosshairIndicator crosshairIndicator = new CrosshairIndicator();
        StringConverter<Number> stringConverter = new StringConverter<Number>(){

            public Number fromString(String string) {
                return null;
            }

            public String toString(Number t) {
                return "";
            }
        };
        crosshairIndicator.setXValueFormatter(stringConverter);
        crosshairIndicator.setYValueFormatter(stringConverter);
        chart.getPlugins().addAll((Object[])new ChartPlugin[]{zoomer, dataPointTooltip, tableViewer, panner});
        return chart;
    }

    public static void removeStyleSheetOnSceneChange(Chart chart) {
        chart.sceneProperty().addListener((observable, s0, s1) -> {
            if (s1 != null) {
                s1.getStylesheets().clear();
            }
        });
    }

    public static void zoomOrigin(Chart chart) {
        for (ChartPlugin plugin : chart.getPlugins()) {
            if (!(plugin instanceof Zoomer)) continue;
            Zoomer zoomer = (Zoomer)plugin;
            zoomer.zoomOrigin();
            break;
        }
    }
}

