/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import org.openide.filesystems.FileUtil;

public class ActionHelper {
    public static void add(ActionMap actionMap, String key, final Runnable runnable) {
        actionMap.put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        });
    }

    public static Action getAction(String category, String id) {
        String path = "%s/%s.instance".formatted(category, id.replace(".", "-"));
        return (Action)FileUtil.getConfigObject((String)path, Action.class);
    }

    public static void remove(ActionMap actionMap, String key) {
        actionMap.remove(key);
    }

    public static void setIconLarge(String category, String id, Icon icon) {
        ActionHelper.setIcon(ActionHelper.getAction(category, id), icon, "SwingLargeIconKey");
    }

    public static void setIconLarge(Action action, Icon icon) {
        ActionHelper.setIcon(action, icon, "SwingLargeIconKey");
    }

    public static void setIconSmall(String category, String id, Icon icon) {
        ActionHelper.setIcon(ActionHelper.getAction(category, id), icon, "SmallIcon");
    }

    public static void setIconSmall(Action action, Icon icon) {
        ActionHelper.setIcon(action, icon, "SmallIcon");
    }

    private static void setIcon(Action action, Icon icon, String key) {
        if (action != null) {
            action.putValue(key, icon);
        } else {
            System.err.println("Action not fond: " + String.valueOf(action));
        }
    }
}

