/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import se.trixon.almond.util.Dict;

public class FileRemover {
    private final Set<String> mDeniedRemoves = new HashSet<String>();

    public Set<String> getDeniedRemoves() {
        return this.mDeniedRemoves;
    }

    public boolean isSuccessful() {
        return this.mDeniedRemoves.isEmpty();
    }

    public boolean remove(String[] paths) {
        this.mDeniedRemoves.clear();
        boolean filesRemoved = false;
        int numOfFiles = paths.length;
        if (numOfFiles > 0) {
            String message;
            String title = numOfFiles == 1 ? Dict.Dialog.TITLE_REMOVE_FILE.toString() : Dict.Dialog.TITLE_REMOVE_FILES.toString();
            String string = message = numOfFiles == 1 ? Dict.Dialog.MESSAGE_REMOVE_FILE.toString() : Dict.Dialog.MESSAGE_REMOVE_FILES.toString();
            if (numOfFiles == 1) {
                message = message.formatted(paths[0]);
            } else {
                StringBuilder builder = new StringBuilder();
                for (String path : paths) {
                    builder.append(path).append("\n");
                }
                builder.deleteCharAt(builder.length() - 1);
                message = message.formatted(numOfFiles, builder.toString());
            }
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)message, title, 0, 3, null, null);
            Object result = DialogDisplayer.getDefault().notify(notifyDescriptor);
            if (result == NotifyDescriptor.YES_OPTION) {
                for (String path : paths) {
                    try {
                        File file = new File(path);
                        FileObject fileObject = FileUtil.createData((File)file);
                        fileObject.delete();
                    }
                    catch (IOException ex) {
                        this.mDeniedRemoves.add(path);
                    }
                }
                filesRemoved = true;
            }
        }
        return filesRemoved;
    }
}

