/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class Monitor {
    private DateTimeFormatter mDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH.mm.ss: ");
    private OutputWriter mErr;
    private final InputOutput mIo;
    private OutputWriter mOut;
    private boolean mUseTimestamps = true;

    public Monitor(String tag, boolean newIO, boolean useTimestamps) {
        this.mUseTimestamps = useTimestamps;
        this.mIo = IOProvider.getDefault().getIO(tag, newIO);
    }

    public void errln(String message) {
        this.mErr = this.mIo.getErr();
        this.printDate(this.mErr);
        this.mErr.println(message);
        this.mErr.close();
    }

    public boolean isUseTimestamps() {
        return this.mUseTimestamps;
    }

    public void outln(String message) {
        this.mOut = this.mIo.getOut();
        this.printDate(this.mOut);
        this.mOut.println(message);
        this.mOut.close();
    }

    public void outlnEvent(String message) {
        this.mOut = this.mIo.getOut();
        this.printDate(this.mOut);
        this.mOut.println(message);
        this.mOut.close();
    }

    public void setUseTimestamps(boolean useTimestamps) {
        this.mUseTimestamps = useTimestamps;
    }

    private void printDate(OutputWriter anOutputWriter) {
        if (this.mUseTimestamps) {
            anOutputWriter.print(LocalDateTime.now().format(this.mDateTimeFormatter));
        }
    }
}

