/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.dialogs;

import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.border.EmptyBorder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ColorChooserDialog {
    private final JColorChooser mColorChooser = new JColorChooser();
    private final Color mCurrentColor;
    private DialogDescriptor mDialogDescriptor;

    public static Color showDialog(Color color) {
        ColorChooserDialog colorChooser = new ColorChooserDialog(color);
        return colorChooser.mColorChooser.getColor();
    }

    private ColorChooserDialog(Color color) {
        this.mCurrentColor = color;
        this.mColorChooser.setColor(color);
        this.init();
    }

    private void init() {
        String dialogTitle = NbBundle.getMessage(ColorChooserDialog.class, (String)"CTL_DialogTitleColor");
        this.mColorChooser.setBorder(new EmptyBorder(10, 10, 0, 10));
        JButton resetButton = new JButton(NbBundle.getMessage(ColorChooserDialog.class, (String)"CTL_Reset"));
        ActionListener actionListener = actionEvent -> {
            if (actionEvent.getSource() == resetButton) {
                this.mColorChooser.setColor(this.mCurrentColor);
            } else if (this.mDialogDescriptor.getValue() == NotifyDescriptor.CANCEL_OPTION) {
                this.mColorChooser.setColor(this.mCurrentColor);
            }
        };
        this.mDialogDescriptor = new DialogDescriptor((Object)this.mColorChooser, dialogTitle, true, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION, 0, null, actionListener);
        this.mDialogDescriptor.setAdditionalOptions(new Object[]{resetButton});
        DialogDisplayer.getDefault().notify((NotifyDescriptor)this.mDialogDescriptor);
    }
}

