/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.dialogs;

import java.awt.Component;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import se.trixon.almond.nbp.fx.FxDialogPanel;
import se.trixon.almond.util.AboutModel;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.dialogs.about.AboutPane;
import se.trixon.almond.util.swing.SwingHelper;

public class NbAboutFx
extends FxDialogPanel {
    private final transient AboutModel mAboutModel;
    private final transient AboutPane mAboutPane;

    public NbAboutFx(AboutModel aboutModel) {
        this.mAboutModel = aboutModel;
        this.mAboutPane = new AboutPane(aboutModel);
    }

    public void display() {
        this.mAboutPane.reset();
        SwingHelper.makeWindowResizable((Component)((Object)this));
        DialogDescriptor d = new DialogDescriptor((Object)this, Dict.ABOUT_S.toString().formatted(this.mAboutModel.getAppName()), true, new Object[]{Dict.CLOSE.toString()}, (Object)Dict.CLOSE.toString(), 0, null, null);
        this.initFx(() -> {});
        SwingUtilities.invokeLater(() -> {
            this.setPreferredSize(SwingHelper.getUIScaledDim((int)520, (int)400));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        });
    }

    @Override
    protected void fxConstructor() {
        this.setScene(this.createScene());
    }

    private Scene createScene() {
        double scaledFontSize = FxHelper.getScaledFontSize();
        Label appLabel = new Label(this.mAboutModel.getAppName());
        appLabel.setFont(new Font(scaledFontSize * 1.8));
        Label verLabel = new Label("%s %s".formatted(Dict.VERSION.toString(), this.mAboutModel.getAppVersion()));
        verLabel.setFont(new Font(scaledFontSize * 1.2));
        Label dateLabel = new Label(this.mAboutModel.getAppDate());
        dateLabel.setFont(new Font(scaledFontSize * 1.2));
        VBox box = new VBox(new Node[]{appLabel, verLabel, dateLabel});
        box.setAlignment(Pos.CENTER_LEFT);
        box.setPadding(new Insets(0.0, 0.0, 0.0, 22.0));
        BorderPane topBorderPane = new BorderPane((Node)box);
        topBorderPane.setLeft((Node)this.mAboutModel.getLogo());
        topBorderPane.setPadding(new Insets(22.0));
        BorderPane mainBorderPane = new BorderPane((Node)this.mAboutPane);
        mainBorderPane.setTop((Node)topBorderPane);
        return new Scene((Parent)mainBorderPane);
    }
}

