/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.dialogs;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import org.apache.commons.lang3.StringUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbPreferences;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.OptionsBase;

public class NbOptionalDialog {
    private static final Options sOptions = new Options();

    public static boolean requestShowDialog(Class cls, String id, int messageType, String title, String message, String checkBoxText) {
        String key = cls.getName() + "_" + id;
        if (sOptions.is(key, new boolean[]{true})) {
            JCheckBox checkBox = new JCheckBox(StringUtils.defaultString((String)checkBoxText, (String)Dict.SHOW_THIS_AGAIN.toString()));
            checkBox.setSelected(true);
            Object[] options = new String[]{Dict.CLOSE.toString()};
            DialogDescriptor d = new DialogDescriptor((Object)message, title, true, options, (Object)Dict.CLOSE.toString(), 0, null, null);
            d.setMessageType(messageType);
            d.setAdditionalOptions(new Object[]{checkBox});
            d.setClosingOptions(options);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            sOptions.put(key, checkBox.isSelected());
            return true;
        }
        return false;
    }

    public static void reset(String key) {
        sOptions.put(key, true);
    }

    public static void resetAll() {
        try {
            sOptions.getPreferences().clear();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(NbOptionalDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void setPreferences(Preferences preferences) {
        sOptions.setPreferences(preferences);
    }

    public static class Options
    extends OptionsBase {
        public Options() {
            this.setPreferences(NbPreferences.forModule(NbOptionalDialog.class).node("optionalDialogState"));
        }
    }
}

