/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.imageviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import se.trixon.almond.util.Scaler;

public class ImagePanel
extends JPanel {
    private transient Image mImage;
    private Dimension mImageDimension = new Dimension();
    private boolean mIsTransparentAdd = true;
    private transient Paint mPaint;

    public ImagePanel() {
    }

    public ImagePanel(Image image) {
        this.setImage(image);
        this.setLayout(new BorderLayout());
    }

    public ImagePanel(Paint painter) {
        this.setPaint(painter);
        this.setLayout(new BorderLayout());
    }

    public void add(JComponent component) {
        this.add(component, null);
    }

    public void add(JComponent component, Object constraints) {
        if (this.mIsTransparentAdd) {
            this.makeComponentTransparent(component);
        }
        super.add((Component)component, constraints);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mImage == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.mImage.getWidth(null), this.mImage.getHeight(null));
    }

    public void setImage(Image image) {
        this.mImage = image;
        this.mImageDimension = image == null ? new Dimension(0, 0) : new Dimension(image.getWidth(null), image.getHeight(null));
        this.repaint();
    }

    public void setPaint(Paint painter) {
        this.mPaint = painter;
        this.repaint();
    }

    public void setTransparentAdd(boolean isTransparentAdd) {
        this.mIsTransparentAdd = isTransparentAdd;
    }

    private void drawImage(Graphics g) {
        Dimension panelDimension = this.getSize();
        Scaler scaler = new Scaler(new Dimension(this.mImageDimension));
        scaler.setHeight(panelDimension.height);
        scaler.setWidth(panelDimension.width);
        Dimension scaledImage = scaler.getDimension();
        int x = (panelDimension.width - scaledImage.width) / 2;
        int y = (panelDimension.height - scaledImage.height) / 2;
        g.drawImage(this.mImage, x, y, scaledImage.width, scaledImage.height, this);
    }

    private void makeComponentTransparent(JComponent component) {
        component.setOpaque(false);
        if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)component;
            JViewport viewport = scrollPane.getViewport();
            viewport.setOpaque(false);
            Component c = viewport.getView();
            if (c instanceof JComponent) {
                JComponent compoment2 = (JComponent)c;
                compoment2.setOpaque(false);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mPaint != null) {
            Dimension d = this.getSize();
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.mPaint);
            g2.fill(new Rectangle(0, 0, d.width, d.height));
        }
        if (this.mImage == null) {
            return;
        }
        this.drawImage(g);
    }
}

