/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.core.news;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import se.trixon.almond.nbp.core.news.NewsItem;
import se.trixon.almond.nbp.core.news.NewsProvider;

public class NewsBuilder {
    private static final Logger LOGGER = Logger.getLogger(NewsBuilder.class.getName());
    private final Map<String, LinkedList<NewsItem>> mDateNewItemsMap = new HashMap<String, LinkedList<NewsItem>>();

    public StringBuilder getNews() {
        Collection newsProviders = Lookup.getDefault().lookupAll(NewsProvider.class);
        newsProviders.stream().forEach(provider -> {
            String bundlePath = provider.getBundlePath();
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(bundlePath, Locale.getDefault(), provider.getClass().getClassLoader());
                if (bundle != null) {
                    String name = provider.getHeading();
                    bundle.keySet().stream().forEach(key -> this.getDateCollection((String)key).add(new NewsItem(name, bundle.getString((String)key))));
                } else {
                    LOGGER.log(Level.SEVERE, "Can't load bundle: {0}", bundlePath);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Bundle not found: {0}", bundlePath);
            }
        });
        StringBuilder builder = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(this.mDateNewItemsMap.keySet());
        Collections.sort(keys);
        Collections.reverse(keys);
        keys.stream().forEach(key -> {
            builder.append("<h2>").append((String)key).append("</h2>");
            LinkedList<NewsItem> newsItems = this.mDateNewItemsMap.get(key);
            newsItems.sort((o1, o2) -> o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase()));
            newsItems.stream().forEach(newsItem -> builder.append("<p><strong>").append(newsItem.getName()).append(":</strong> ").append(newsItem.getNews()).append("</p>"));
        });
        return builder;
    }

    private LinkedList<NewsItem> getDateCollection(String key) {
        if (!this.mDateNewItemsMap.containsKey(key)) {
            this.mDateNewItemsMap.put(key, new LinkedList());
        }
        return this.mDateNewItemsMap.get(key);
    }
}

