/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.geonames_ww;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import org.mapton.addon.geonames_ww.Bundle;
import org.mapton.api.Mapton;
import org.mapton.geonames.api.Country;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.analytic.AnalyticGrid;
import org.mapton.worldwind.api.analytic.CellAggregate;
import org.mapton.worldwind.api.analytic.GridData;
import org.mapton.worldwind.api.analytic.GridValue;

public class GeoNamesLayerBundle
extends LayerBundle {
    private final RenderableLayer mLayer = new RenderableLayer();

    public GeoNamesLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    public void populate() {
        this.getLayers().add((Object)this.mLayer);
    }

    private GridData getGridData(Country country) {
        ArrayList values = new ArrayList();
        country.getGeonames().forEach(geoname -> values.add(new GridValue(geoname.getLatLon(), Double.valueOf(geoname.getPopulation().intValue()))));
        int width = 100;
        int height = 100;
        return new GridData(width, height, values, CellAggregate.SUM);
    }

    private void init() {
        this.mLayer.setName(Bundle.CTL_GeoNamesAction());
        this.setCategoryAddOns((Layer)this.mLayer);
        this.attachTopComponentToLayer("GeoNamesTopComponent", (Layer)this.mLayer);
        this.mLayer.setPickEnabled(false);
        this.mLayer.setEnabled(true);
        this.setName("GeoNames");
    }

    private void initListeners() {
        Mapton.getGlobalState().addListener(gsce -> this.repaint(0L), new String[]{"geoname.list.selection"});
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            ObservableList countries = (ObservableList)Mapton.getGlobalState().get("geoname.list.selection");
            int altitude = 50000;
            int minValue = 0;
            int maxValue = 100000;
            countries.stream().filter(country -> country.getGeonames().size() > 1).map(country -> {
                AnalyticGrid analyticGrid = new AnalyticGrid(this.mLayer, (double)altitude, (double)minValue, (double)maxValue);
                analyticGrid.setNullOpacity(0.0);
                analyticGrid.setZeroOpacity(0.3);
                analyticGrid.setZeroValueSearchRange(5);
                analyticGrid.setGridData(this.getGridData((Country)country));
                return analyticGrid;
            }).forEachOrdered(analyticGrid -> this.mLayer.addRenderable((Renderable)analyticGrid.getSurface()));
            this.setDragEnabled(false);
        });
    }
}

