/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.files;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javax.swing.SwingUtilities;
import org.controlsfx.control.CheckListView;
import org.controlsfx.control.IndexedCheckModel;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.api.MCoordinateFile;
import org.mapton.api.MCoordinateFileManager;
import org.mapton.api.Mapton;
import org.mapton.api.ui.MOptionsPopOver;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class FilesPane
extends BorderPane {
    private List<Action> mActions;
    private final CheckListView<MCoordinateFile> mListView = new CheckListView();
    private final MCoordinateFileManager mManager = MCoordinateFileManager.getInstance();
    private Action mRefreshAction;

    public FilesPane() {
        this.createUI();
        this.refreshCheckedStates();
        this.initListeners();
    }

    private void createUI() {
        Action closeAction = new Action(Dict.CLOSE.toString(), event -> {
            if (this.getSelected() != null) {
                this.remove();
            }
        });
        closeAction.setGraphic((Node)MaterialIcon._Content.REMOVE.getImageView(Mapton.getIconSizeToolBarInt()));
        Action closeAllAction = new Action(Dict.CLOSE_ALL.toString(), event -> {
            if (!this.mListView.getItems().isEmpty()) {
                this.removeAll();
            }
        });
        closeAllAction.setGraphic((Node)MaterialIcon._Content.CLEAR.getImageView(Mapton.getIconSizeToolBarInt()));
        this.mRefreshAction = new Action(Dict.REFRESH.toString(), event -> this.mManager.refresh());
        this.mRefreshAction.setGraphic((Node)MaterialIcon._Navigation.REFRESH.getImageView(Mapton.getIconSizeToolBarInt()));
        MOptionsPopOver optionsPopOver = new MOptionsPopOver();
        optionsPopOver.getAction().setDisabled(true);
        this.mActions = Arrays.asList(closeAction, closeAllAction, ActionUtils.ACTION_SPAN, this.mRefreshAction, optionsPopOver.getAction());
        ToolBar toolBar = ActionUtils.createToolBar(this.mActions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)toolBar.getItems().stream(), (double)Mapton.getIconSizeToolBarInt());
        FxHelper.undecorateButtons((Stream)toolBar.getItems().stream());
        FxHelper.slimToolBar((ToolBar)toolBar);
        this.setTop((Node)toolBar);
        this.setCenter((Node)this.mListView);
        this.mListView.itemsProperty().bind((ObservableValue)this.mManager.itemsProperty());
    }

    private MCoordinateFile getSelected() {
        return (MCoordinateFile)this.mListView.getSelectionModel().getSelectedItem();
    }

    private void initListeners() {
        this.mListView.getSelectionModel().getSelectedItems().addListener(c -> {
            if (this.getSelected() != null) {
                // empty if block
            }
        });
        this.mManager.getItems().addListener(c -> {
            this.refreshCheckedStates();
            try {
                this.mManager.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
        IndexedCheckModel checkModel = this.mListView.getCheckModel();
        checkModel.getCheckedItems().addListener(c -> Platform.runLater(() -> {
            this.mManager.getItems().forEach(document -> document.setVisible(checkModel.isChecked(document)));
            try {
                this.mManager.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }));
    }

    private void refreshCheckedStates() {
        IndexedCheckModel checkModel = this.mListView.getCheckModel();
        for (MCoordinateFile document : this.mManager.getItems()) {
            if (document.isVisible()) {
                checkModel.check((Object)document);
                continue;
            }
            checkModel.clearCheck((Object)document);
        }
    }

    private void remove() {
        MCoordinateFile document = this.getSelected();
        SwingUtilities.invokeLater(() -> {
            Object[] buttons = new String[]{Dict.CANCEL.toString(), Dict.CLOSE.toString()};
            NotifyDescriptor d = new NotifyDescriptor((Object)Dict.Dialog.MESSAGE_FILE_CLOSE.toString().formatted(document.getFile().getName()), Dict.Dialog.TITLE_CLOSE_S.toString().formatted(Dict.FILE.toString().toLowerCase()) + "?", 2, 2, buttons, (Object)Dict.CLOSE.toString());
            if (Dict.CLOSE.toString() == DialogDisplayer.getDefault().notify(d)) {
                Platform.runLater(() -> this.mManager.removeAll(new MCoordinateFile[]{document}));
            }
        });
    }

    private void removeAll() {
        SwingUtilities.invokeLater(() -> {
            Object[] buttons = new String[]{Dict.CANCEL.toString(), Dict.CLOSE_ALL.toString()};
            NotifyDescriptor d = new NotifyDescriptor((Object)Dict.Dialog.MESSAGE_FILE_CLOSE_ALL.toString(), Dict.Dialog.TITLE_FILE_CLOSE_ALL.toString() + "?", 2, 2, buttons, (Object)Dict.CLOSE_ALL.toString());
            if (Dict.CLOSE_ALL.toString() == DialogDisplayer.getDefault().notify(d)) {
                Platform.runLater(() -> this.mManager.removeAll(new MCoordinateFile[0]));
            }
        });
    }
}

