/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.wikipedia;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapton.addon.wikipedia.api.WikipediaArticle;
import org.mapton.addon.wikipedia.api.WikipediaArticleManager;
import org.mapton.addon.wikipedia.result.ApiResult;
import org.mapton.addon.wikipedia.result.Coordinate;
import org.mapton.addon.wikipedia.result.Page;
import org.mapton.addon.wikipedia.result.Terms;
import org.mapton.addon.wikipedia.result.Thumbnail;
import org.mapton.api.MContextMenuItem;
import org.mapton.api.MLatLon;
import org.mapton.api.Mapton;
import org.openide.util.Exceptions;
import se.trixon.almond.nbp.Almond;

public class WikipediaContextExtras
extends MContextMenuItem {
    protected Locale mLocale = Locale.getDefault();
    private final WikipediaArticleManager mWikipediaManager = WikipediaArticleManager.getInstance();

    public EventHandler<ActionEvent> getAction() {
        return event -> {
            Almond.openAndActivateTopComponent((String)"WikipediaTopComponent");
            String base = String.format(Locale.ENGLISH, "https://%s.wikipedia.org/w/api.php?action=query", this.mLocale.getLanguage());
            int limit = 1000;
            int coLimit = 1000;
            int piLimit = 1000;
            int ggsLimit = 1000;
            int thumbSize = 50;
            int radius = 10000;
            String template = String.format(Locale.ENGLISH, "&prop=coordinates|pageimages|pageterms&colimit=max&pilimit=max&ggslimit=max&piprop=thumbnail&pithumbsize=%d&wbptterms=description&generator=geosearch&ggscoord=%f|%f&ggsradius=%d&format=json&servedby=1&curtimestamp=1&responselanginfo=1", 50, this.getLatitude(), this.getLongitude(), 10000);
            try {
                URL url = new URL(base + StringUtils.replaceEach((String)URLEncoder.encode(template, "utf-8"), (String[])new String[]{"%26", "%3D"}, (String[])new String[]{"&", "="}));
                Mapton.getLog().v("Wikipedia", url.toString());
                this.mWikipediaManager.setLocale(this.mLocale);
                this.mWikipediaManager.getAllItems().clear();
                new Thread(() -> {
                    try {
                        String json = IOUtils.toString((URL)url, (String)"utf-8");
                        ApiResult result = ApiResult.load(json);
                        ArrayList<WikipediaArticle> articles = new ArrayList<WikipediaArticle>();
                        if (result.getQuery() != null && result.getQuery().getPages() != null) {
                            LinkedHashMap<String, Page> pages = result.getQuery().getPages();
                            Mapton.getLog().v("Wikipedia", "Found %d articles".formatted(pages.size()));
                            for (Page page : pages.values()) {
                                Terms terms;
                                WikipediaArticle article = new WikipediaArticle();
                                article.setTitle(page.getTitle());
                                Coordinate coordinate = page.getCoordinates().get(0);
                                MLatLon latLon = new MLatLon(coordinate.getLat(), coordinate.getLon());
                                article.setLatLon(latLon);
                                article.setDistance(latLon.distance(new MLatLon(this.getLatitude(), this.getLongitude())));
                                Thumbnail thumbnail = page.getThumbnail();
                                if (thumbnail != null) {
                                    article.setThumbnail(thumbnail.getSource());
                                    article.setThumbnailHeight(thumbnail.getHeight());
                                    article.setThumbnailWidth(thumbnail.getWidth());
                                }
                                if ((terms = page.getTerms()) != null && terms.getDescription() != null && terms.getDescription().length > 0) {
                                    article.setDescription(terms.getDescription()[0]);
                                }
                                articles.add(article);
                            }
                        }
                        Collections.sort(articles, (o1, o2) -> o1.getDistance().compareTo(o2.getDistance()));
                        this.mWikipediaManager.getAllItems().addAll(articles);
                        if (!articles.isEmpty()) {
                            this.mWikipediaManager.setSelectedItem((WikipediaArticle)articles.get(0));
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        };
    }

    public String getName() {
        return "Wikipedia";
    }

    public MContextMenuItem.ContextType getType() {
        return MContextMenuItem.ContextType.EXTRAS;
    }
}

